/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.Element;
import org.crsh.text.ui.LabelRenderer;
import org.crsh.util.CharSlicer;
import org.crsh.util.Pair;

public class LabelElement
extends Element {
    final String value;
    final int minWidth;
    final int actualWidth;
    final int actualHeight;
    final CharSlicer slicer;

    public LabelElement(String value, int minWidth) {
        if (minWidth < 0) {
            throw new IllegalArgumentException("No negative min size allowed");
        }
        CharSlicer slicer = new CharSlicer(value);
        Pair<Integer, Integer> size = slicer.size();
        this.value = value;
        this.minWidth = Math.min(size.getFirst(), minWidth);
        this.actualWidth = size.getFirst();
        this.actualHeight = size.getSecond();
        this.slicer = slicer;
    }

    public LabelElement(String value) {
        this(value, 1);
    }

    public LabelElement(Object value, int minWidth) {
        this(String.valueOf(value), minWidth);
    }

    public LabelElement(Object value) {
        this(String.valueOf(value));
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Renderer renderer() {
        return new LabelRenderer(this);
    }

    public String toString() {
        return "Label[" + this.value + "]";
    }

    @Override
    public LabelElement style(Style.Composite style) {
        return (LabelElement)super.style(style);
    }
}

