/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.crsh.util.Safe;

public abstract class AbstractSocketClient
implements Closeable {
    private int port;
    private Socket socket;
    private InputStream in;
    private OutputStream out;

    public AbstractSocketClient(int port) {
        this.port = port;
    }

    public final void connect() throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(this.port));
        InputStream in = socket.getInputStream();
        OutputStream out = socket.getOutputStream();
        this.socket = socket;
        this.in = in;
        this.out = out;
        this.handle(in, out);
    }

    protected abstract void handle(InputStream var1, OutputStream var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        try {
            Safe.close(this.socket);
            Safe.close(this.in);
            Safe.close(this.out);
        }
        finally {
            this.socket = null;
            this.in = null;
            this.out = null;
        }
    }
}

