/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.crsh.util.IO;
import org.crsh.util.Utils;
import org.crsh.vfs.Key;
import org.crsh.vfs.Resource;
import org.crsh.vfs.spi.FSDriver;

class Handle<H> {
    private final FSDriver<H> driver;
    final Key key;
    final H handle;

    Handle(FSDriver<H> driver, H handle) throws IOException {
        String name = driver.name(handle);
        boolean dir = driver.isDir(handle);
        this.driver = driver;
        this.handle = handle;
        this.key = new Key(name, dir);
    }

    Iterable<Handle<H>> children() throws IOException {
        ArrayList<Handle<H>> children = new ArrayList<Handle<H>>();
        for (H h : this.driver.children(this.handle)) {
            children.add(new Handle<H>(this.driver, h));
        }
        return children;
    }

    Resource getResource() throws IOException {
        InputStream in = this.open();
        byte[] bytes = IO.readAsBytes(in);
        long lastModified = this.getLastModified();
        return new Resource(bytes, lastModified);
    }

    Iterator<Resource> getResources() throws IOException {
        Iterator<InputStream> i = this.driver.open(this.handle);
        if (i.hasNext()) {
            LinkedList<Resource> resources = new LinkedList<Resource>();
            while (i.hasNext()) {
                InputStream in = i.next();
                byte[] bytes = IO.readAsBytes(in);
                long lastModified = this.getLastModified();
                resources.add(new Resource(bytes, lastModified));
            }
            return resources.iterator();
        }
        return Utils.iterator();
    }

    private InputStream open() throws IOException {
        Iterator<InputStream> i = this.driver.open(this.handle);
        if (i.hasNext()) {
            return i.next();
        }
        throw new IOException("No stream");
    }

    long getLastModified() throws IOException {
        return this.driver.getLastModified(this.handle);
    }
}

