/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.repl;

import java.util.ArrayList;
import java.util.Arrays;
import org.crsh.cli.Command;
import org.crsh.command.CRaSHCommand;
import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.Commands;

public class REPLTestCase
extends AbstractCommandTestCase {
    public static final ArrayList<Object> list = new ArrayList();

    public void testResolveContext() {
        Object context = this.groovyShell.evaluate("context");
        REPLTestCase.assertNotNull((Object)context);
    }

    public void testConfigureOptionWithClosure() {
        this.lifeCycle.bind("parameterized", Commands.Parameterized.class);
        this.assertOk("repl groovy");
        list.clear();
        Commands.Parameterized.reset();
        this.assertOk("(parameterized { opt = 'toto_opt'; })()");
        REPLTestCase.assertEquals((String)"toto_opt", (String)Commands.Parameterized.opt);
    }

    public void testConfigureArgumentWithClosure() {
        this.lifeCycle.bind("parameterized", Commands.Parameterized.class);
        this.assertOk("repl groovy");
        list.clear();
        Commands.Parameterized.reset();
        this.assertOk("(parameterized { 'toto_arg'; })()");
        REPLTestCase.assertEquals(null, (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(Arrays.asList("toto_arg"), Commands.Parameterized.args);
    }

    public void testConfigureArgumentListWithClosure() {
        this.lifeCycle.bind("parameterized", Commands.Parameterized.class);
        this.assertOk("repl groovy");
        list.clear();
        Commands.Parameterized.reset();
        this.assertOk("(parameterized { ['toto_arg_1', 'toto_arg_2']; })()");
        REPLTestCase.assertEquals(null, (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(Arrays.asList("toto_arg_1", "toto_arg_2"), Commands.Parameterized.args);
    }

    public void testConfigureArgumentArrayWithClosure() {
        this.lifeCycle.bind("parameterized", Commands.Parameterized.class);
        this.assertOk("repl groovy");
        list.clear();
        Commands.Parameterized.reset();
        this.assertOk("(parameterized { ['toto_arg_1', 'toto_arg_2'] as Object[]; })()");
        REPLTestCase.assertEquals(null, (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(Arrays.asList("toto_arg_1", "toto_arg_2"), Commands.Parameterized.args);
    }

    public void testResolveContextInClosure() {
        this.lifeCycle.bind("produce", Commands.ProduceString.class);
        this.assertOk("repl groovy");
        String result = this.assertOk("(produce | { String it -> context.provide(it) })()");
        REPLTestCase.assertEquals((String)"foobar", (String)result);
    }

    public void testReturnValueInClosure() {
        this.lifeCycle.bind("produce", Commands.ProduceString.class);
        this.assertOk("repl groovy");
        String result = this.assertOk("(produce | { String it -> it })()");
        REPLTestCase.assertEquals((String)"foobar", (String)result);
    }

    public void testClosureInPipe() {
        this.lifeCycle.bind("produce", Commands.ProduceString.class);
        this.lifeCycle.bind("consume", Commands.ConsumeString.class);
        this.assertOk("repl groovy");
        Commands.list.clear();
        this.assertOk("(produce | { String it -> '_' + it + '_' } | consume)()");
        REPLTestCase.assertEquals(Arrays.asList("_foo_", "_bar_"), Commands.list);
    }

    public void testCommandInClosure() {
        this.lifeCycle.bind("produce", Commands.ProduceString.class);
        this.lifeCycle.bind("value", Commands.ProduceInteger.class);
        this.lifeCycle.bind("consume", Commands.ConsumeInteger.class);
        this.assertOk("repl groovy");
        Commands.list.clear();
        this.assertOk("(produce | { String it -> value(); } | consume)()");
        REPLTestCase.assertEquals(Arrays.asList(3, 3), Commands.list);
    }

    public void testSubCommandInClosure() {
        this.lifeCycle.bind("produce", Commands.ProduceInteger.class);
        this.lifeCycle.bind("toto", "public class toto {\n@Command\npublic void sub(InvocationContext<String> c) {\nc.provide('foo');\n}\n}");
        this.lifeCycle.bind("consume", Commands.ConsumeString.class);
        this.assertOk("repl groovy");
        Commands.list.clear();
        this.assertOk("(produce | { Integer it -> toto.sub(); } | consume)()");
        REPLTestCase.assertEquals(Arrays.asList("foo"), Commands.list);
    }

    public void testSubCommand() {
        this.lifeCycle.bind("toto", Toto.class);
        this.assertOk("repl groovy");
        String result = this.assertOk("toto.sub()");
        REPLTestCase.assertEquals((String)"invoked", (String)result);
    }

    public void testSubCommandOverridesGDK() {
        this.lifeCycle.bind("toto", Toto.class);
        this.assertOk("repl groovy");
        String result = this.assertOk("toto.find()");
        REPLTestCase.assertEquals((String)"find_invoked", (String)result);
        this.assertOk("toto.find");
    }

    public void testProvideToContext() {
        this.assertOk("repl groovy");
        String result = this.assertOk("context << 'hello'");
        REPLTestCase.assertTrue((boolean)result.startsWith("hello"));
    }

    public void testPipe() {
        this.lifeCycle.bind("produce", Commands.ProduceString.class);
        this.lifeCycle.bind("consume", Commands.ConsumeString.class);
        this.assertOk("repl groovy");
        Commands.list.clear();
        this.assertOk("(produce | consume)()");
        REPLTestCase.assertEquals(Arrays.asList("foo", "bar"), Commands.list);
    }

    public void testOptions() {
        this.lifeCycle.bind("parameterized", Commands.Parameterized.class);
        this.assertOk("repl groovy");
        Commands.Parameterized.reset();
        this.assertOk("a = parameterized { opt = 'foo_opt' }");
        REPLTestCase.assertEquals(null, (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(null, Commands.Parameterized.args);
        this.assertOk("a()");
        REPLTestCase.assertEquals((String)"foo_opt", (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(null, Commands.Parameterized.args);
    }

    public void testArgs() {
        this.lifeCycle.bind("parameterized", Commands.Parameterized.class);
        this.assertOk("repl groovy");
        Commands.Parameterized.reset();
        this.assertOk("a = parameterized { ['arg1', 'arg2'] }");
        REPLTestCase.assertEquals(null, (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(null, Commands.Parameterized.args);
        this.assertOk("a()");
        REPLTestCase.assertEquals(null, (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(Arrays.asList("arg1", "arg2"), Commands.Parameterized.args);
    }

    public void testOptionsAndArgs() {
        this.lifeCycle.bind("parameterized", Commands.Parameterized.class);
        this.assertOk("repl groovy");
        Commands.Parameterized.reset();
        this.assertOk("a = parameterized { opt = 'foo_opt'; ['arg1', 'arg2'] }");
        REPLTestCase.assertEquals(null, (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(null, Commands.Parameterized.args);
        this.assertOk("a()");
        REPLTestCase.assertEquals((String)"foo_opt", (String)Commands.Parameterized.opt);
        REPLTestCase.assertEquals(Arrays.asList("arg1", "arg2"), Commands.Parameterized.args);
    }

    public static class Toto
    extends CRaSHCommand {
        @Command
        public String sub() {
            return "invoked";
        }

        @Command
        public String find() {
            return "find_invoked";
        }
    }
}

