/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import org.crsh.shell.AbstractCommandTestCase;
import org.crsh.shell.Commands;

public class DispatchTestCase
extends AbstractCommandTestCase {
    public void testInvokeCompound() throws Exception {
        String foo = "class foo {\n@Command\npublic String main() {\ncompound_command.compound 'bar'\n}\n}";
        this.lifeCycle.bind("compound_command", Commands.Compound.class);
        this.lifeCycle.bind("foo", foo);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testProduceToClosure() {
        String foo = "class foo {\n@Command\npublic void main() {\nproduce_command { it }\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("produce_command", Commands.ProduceString.class);
        DispatchTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
    }

    public void testProduceToClosureInScript() {
        this.lifeCycle.bind("foo", "produce_command { it }\n");
        this.lifeCycle.bind("produce_command", Commands.ProduceString.class);
        DispatchTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
    }

    public void testClosure() {
        String foo = "class foo {\n@Command\npublic void main() {\ndef closure = echo\nclosure 'bar'\n}\n}";
        this.lifeCycle.bind("foo", foo);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testClosureInScript() {
        String foo = "def closure = echo\nclosure 'bar'\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("compound_command", Commands.Compound.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCompoundClosure() {
        String foo = "class foo {\n@Command\npublic void main() {\ndef closure = compound_command.compound\nclosure()\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("compound_command", Commands.Compound.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCompoundClosureInScript() {
        String foo = "def closure = compound_command.compound\nclosure()\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("compound_command", Commands.Compound.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCompoundProduceToClosure() {
        String foo = "class foo {\n@Command\npublic void main() {\n(compound_produce_command.compound | { it })()\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("compound_produce_command", Commands.CompoundProduceString.class);
        DispatchTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
        String bar = "class bar {\n@Command\npublic void main() {\n(compound_produce_command.compound | { boolean it -> it })()\n}\n}";
        this.lifeCycle.bind("bar", bar);
        this.lifeCycle.bind("compound_produce_command", Commands.CompoundProduceString.class);
        DispatchTestCase.assertEquals((String)"", (String)this.assertOk("bar"));
    }

    public void testCompoundProduceToClosureInScript() {
        String foo = "(compound_produce_command.compound | { it })()\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("compound_produce_command", Commands.CompoundProduceString.class);
        DispatchTestCase.assertEquals((String)"foobar", (String)this.assertOk("foo"));
        String bar = "(compound_produce_command.compound | { boolean it -> it })()\n";
        this.lifeCycle.bind("bar", bar);
        this.lifeCycle.bind("compound_produce_command", Commands.CompoundProduceString.class);
        DispatchTestCase.assertEquals((String)"", (String)this.assertOk("bar"));
    }

    public void testInvokeCompoundInScript() throws Exception {
        String foo = "compound_command.compound 'bar'\n";
        this.lifeCycle.bind("compound_command", Commands.Compound.class);
        this.lifeCycle.bind("foo", foo);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCheckedException() {
        String foo = "class foo {\n@Command\npublic String main() {\ntry {checked_exception_command()} catch(javax.naming.NamingException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("checked_exception_command", Commands.ThrowCheckedException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCheckedExceptionInScript() {
        String foo = "try {checked_exception_command()} catch(javax.naming.NamingException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("checked_exception_command", Commands.ThrowCheckedException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testScriptException() {
        String foo = "class foo {\n@Command\npublic String main() {\ntry {script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("script_exception_command", Commands.ThrowScriptException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testScriptExceptionInScript() {
        String foo = "try {script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("script_exception_command", Commands.ThrowScriptException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testGroovyScriptException() {
        String foo = "class foo {\n@Command\npublic String main() {\ntry {groovy_script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("groovy_script_exception_command", Commands.ThrowGroovyScriptException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testGroovyScriptExceptionInScript() {
        String foo = "try {groovy_script_exception_command()} catch(org.crsh.command.ScriptException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("groovy_script_exception_command", Commands.ThrowGroovyScriptException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testRuntimeException() {
        String foo = "class foo {\n@Command\npublic String main() {\ntry {runtime_exception_command()} catch(java.lang.SecurityException e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("runtime_exception_command", Commands.ThrowRuntimeException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testRuntimeExceptionInScript() {
        String foo = "try {runtime_exception_command()} catch(java.lang.SecurityException e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("runtime_exception_command", Commands.ThrowRuntimeException.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testError() {
        String foo = "class foo {\n@Command\npublic String main() {\ntry {error_command()} catch(java.awt.AWTError e) {\nreturn 'bar'\n}\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("error_command", Commands.ThrowError.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testErrorInScript() {
        String foo = "try {error_command()} catch(java.awt.AWTError e) {\nreturn 'bar'\n}\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("error_command", Commands.ThrowError.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCannotCreateCommand() {
        String foo = "class foo {\n@Command\npublic String main() {\ntry {\ncannot_create_command()} catch (org.crsh.command.NoSuchCommandException e) {\nreturn 'bar';\n}\n}\n}";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("cannot_create_command", Commands.CannotInstantiate.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }

    public void testCannotCreateCommandInScript() {
        String foo = "try {\ncannot_create_command()} catch (org.crsh.command.NoSuchCommandException e) {\nreturn 'bar';\n}\n";
        this.lifeCycle.bind("foo", foo);
        this.lifeCycle.bind("cannot_create_command", Commands.CannotInstantiate.class);
        DispatchTestCase.assertEquals((String)"bar", (String)this.assertOk("foo"));
    }
}

