/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import junit.framework.TestCase;
import org.crsh.util.Safe;

public class SafeTestCase
extends TestCase {
    public void testClose() {
        Exception closed = Safe.close((Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
            }
        });
        SafeTestCase.assertNull((Object)closed);
        final IOException ioe = new IOException();
        closed = Safe.close((Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                throw ioe;
            }
        });
        SafeTestCase.assertSame((Object)ioe, (Object)closed);
        final RuntimeException re = new RuntimeException();
        closed = Safe.close((Closeable)new Closeable(){

            @Override
            public void close() throws IOException {
                throw re;
            }
        });
        SafeTestCase.assertSame((Object)re, (Object)closed);
        final Error thrown = new Error();
        try {
            Safe.close((Closeable)new Closeable(){

                @Override
                public void close() throws IOException {
                    throw thrown;
                }
            });
        }
        catch (Error caught) {
            SafeTestCase.assertSame((Object)thrown, (Object)caught);
        }
    }

    public void testFlush() {
        Exception flushed = Safe.flush((Flushable)new Flushable(){

            @Override
            public void flush() throws IOException {
            }
        });
        SafeTestCase.assertNull((Object)flushed);
        final IOException ioe = new IOException();
        flushed = Safe.flush((Flushable)new Flushable(){

            @Override
            public void flush() throws IOException {
                throw ioe;
            }
        });
        SafeTestCase.assertSame((Object)ioe, (Object)flushed);
        final RuntimeException re = new RuntimeException();
        flushed = Safe.flush((Flushable)new Flushable(){

            @Override
            public void flush() throws IOException {
                throw re;
            }
        });
        SafeTestCase.assertSame((Object)re, (Object)flushed);
        final Error thrown = new Error();
        try {
            Safe.flush((Flushable)new Flushable(){

                @Override
                public void flush() throws IOException {
                    throw thrown;
                }
            });
        }
        catch (Error caught) {
            SafeTestCase.assertSame((Object)thrown, (Object)caught);
        }
    }
}

