/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.groovy.closure;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crsh.command.CommandInvoker;
import org.crsh.command.ShellCommand;
import org.crsh.lang.groovy.closure.PipeLineElement;

class CommandElement
extends PipeLineElement {
    final String commandName;
    final ShellCommand command;
    final String name;
    final Map<String, Object> options;
    final List<Object> args;

    public CommandElement(String commandName, ShellCommand command, String name) {
        this.commandName = commandName;
        this.command = command;
        this.name = name;
        this.options = null;
        this.args = null;
    }

    public CommandElement(String commandName, ShellCommand command, String name, Map<String, Object> options, List<Object> args) {
        this.commandName = commandName;
        this.command = command;
        this.name = name;
        this.options = options;
        this.args = args;
    }

    @Override
    CommandInvoker make() {
        return this.command.resolveInvoker(this.name != null ? this.name : "", this.options != null ? this.options : Collections.emptyMap(), this.args != null ? this.args : Collections.emptyList());
    }

    private void format(Object o, StringBuilder buffer) {
        if (o instanceof String) {
            buffer.append('\"').append(o).append('\"');
        } else if (o instanceof Boolean || o instanceof Number) {
            buffer.append(o);
        } else {
            buffer.append('<').append(o).append('>');
        }
    }

    @Override
    void toString(StringBuilder buffer) {
        boolean hasArguments;
        buffer.append(this.commandName);
        boolean hasOptions = this.options != null && this.options.size() > 0;
        boolean bl = hasArguments = this.args != null && this.args.size() > 0;
        if (hasOptions || hasArguments) {
            Iterator<Object> i;
            buffer.append(" {");
            if (hasOptions) {
                i = this.options.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<String, Object> option = i.next();
                    buffer.append(' ').append(option.getKey()).append('=');
                    this.format(option.getValue(), buffer);
                    if (!i.hasNext()) continue;
                    buffer.append(";");
                }
                if (hasArguments) {
                    buffer.append(";");
                }
            }
            if (hasArguments) {
                buffer.append(" [");
                i = this.args.iterator();
                while (i.hasNext()) {
                    Object arg = i.next();
                    this.format(arg, buffer);
                    if (!i.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append("]");
            }
            buffer.append(" }");
        }
    }
}

