/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.script;

import org.crsh.command.SyntaxException;
import org.crsh.lang.script.PipeLineFactory;
import org.crsh.lang.script.Token;
import org.crsh.lang.script.Tokenizer;

public class PipeLineParser {
    private Tokenizer tokenizer;
    private Token token;

    public PipeLineParser(CharSequence s) {
        this.tokenizer = new Tokenizer(s);
        this.token = this.tokenizer.nextToken();
    }

    public PipeLineFactory parse() {
        if (this.token == Token.EOF) {
            return null;
        }
        return this.parseExpr();
    }

    private PipeLineFactory parseExpr() {
        if (this.token instanceof Token.Command) {
            PipeLineFactory next;
            Token.Command command = (Token.Command)this.token;
            this.token = this.tokenizer.nextToken();
            if (this.token == Token.EOF) {
                next = null;
            } else if (this.token == Token.PIPE) {
                this.token = this.tokenizer.nextToken();
                next = this.parseExpr();
            } else {
                throw new SyntaxException("Syntax error");
            }
            return new PipeLineFactory(command.line, next);
        }
        throw new SyntaxException("Syntax error");
    }
}

