/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.spring;

import java.util.Collections;
import java.util.LinkedHashSet;
import org.crsh.auth.JaasAuthenticationPlugin;
import org.crsh.auth.SimpleAuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.SimplePluginDiscovery;
import org.crsh.processor.term.ProcessorIOHandler;
import org.crsh.shell.impl.command.CRaSHShellFactory;
import org.crsh.spring.BeanMap;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringBootstrap
extends PluginLifeCycle
implements BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean,
DisposableBean {
    private ClassLoader loader;
    private BeanFactory factory;

    public void setBeanClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.factory = factory;
    }

    public void afterPropertiesSet() throws Exception {
        Object attributes;
        LinkedHashSet<Object> plugins = new LinkedHashSet<Object>();
        plugins.add(new CRaSHShellFactory());
        plugins.add(new ProcessorIOHandler());
        plugins.add(new JaasAuthenticationPlugin());
        plugins.add(new SimpleAuthenticationPlugin());
        if (this.factory instanceof ListableBeanFactory) {
            ListableBeanFactory listable = (ListableBeanFactory)this.factory;
            plugins.addAll(listable.getBeansOfType(CRaSHPlugin.class).values());
            attributes = new BeanMap(listable);
        } else {
            attributes = Collections.emptyMap();
        }
        SimplePluginDiscovery discovery = new SimplePluginDiscovery(plugins.toArray(new CRaSHPlugin[plugins.size()]));
        FS cmdFS = new FS();
        cmdFS.mount(this.loader, Path.get((String)"/crash/commands/"));
        FS confFS = new FS();
        confFS.mount(this.loader, Path.get((String)"/crash/"));
        PluginContext context = new PluginContext((PluginDiscovery)discovery, attributes, cmdFS, confFS, this.loader);
        context.refresh();
        this.start(context);
    }

    public void destroy() throws Exception {
        this.stop();
    }
}

