/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.processor.jline;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.crsh.processor.jline.JLineProcessor;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;

class JLineProcessContext
implements ShellProcessContext {
    private static final Character NO_ECHO = Character.valueOf('\u0000');
    final JLineProcessor processor;
    final CountDownLatch latch = new CountDownLatch(1);
    final AtomicReference<ShellResponse> resp = new AtomicReference();

    public JLineProcessContext(JLineProcessor processor) {
        this.processor = processor;
    }

    public int getWidth() {
        return this.processor.reader.getTerminal().getWidth();
    }

    public String getProperty(String name) {
        return null;
    }

    public String readLine(String msg, boolean echo) {
        try {
            if (echo) {
                return this.processor.reader.readLine(msg);
            }
            return this.processor.reader.readLine(msg, NO_ECHO);
        }
        catch (IOException e) {
            return null;
        }
    }

    public void end(ShellResponse response) {
        this.resp.set(response);
        this.latch.countDown();
    }
}

