/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.remoting;

import java.io.IOException;
import java.util.ArrayList;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.remoting.ClientAutomaton;
import org.crsh.shell.impl.remoting.ServerMessage;
import org.crsh.text.Chunk;

class ClientProcessContext
implements ShellProcessContext {
    final ClientAutomaton client;
    final ShellProcess process;
    final ArrayList<Chunk> buffer;

    ClientProcessContext(ClientAutomaton client, ShellProcess process) {
        this.client = client;
        this.process = process;
        this.buffer = new ArrayList(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSize() {
        if (System.currentTimeMillis() - this.client.last > 2000L) {
            ClientProcessContext clientProcessContext = this;
            synchronized (clientProcessContext) {
                try {
                    this.client.out.writeObject((Object)ServerMessage.GET_SIZE);
                    this.client.out.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public int getWidth() {
        this.ensureSize();
        return this.client.getWidth();
    }

    public int getHeight() {
        this.ensureSize();
        return this.client.getHeight();
    }

    public boolean takeAlternateBuffer() {
        try {
            this.client.out.writeObject((Object)ServerMessage.USE_ALTERNATE_BUFFER);
            this.client.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public boolean releaseAlternateBuffer() {
        try {
            this.client.out.writeObject((Object)ServerMessage.USE_MAIN_BUFFER);
            this.client.out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String getProperty(String name) {
        return null;
    }

    public String readLine(String msg, boolean echo) {
        return null;
    }

    public void provide(Chunk element) throws IOException {
        this.buffer.add(element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        if (this.buffer.size() > 0) {
            try {
                for (Chunk chunk : this.buffer) {
                    this.client.out.writeObject((Object)ServerMessage.CHUNK);
                    this.client.out.writeObject(chunk);
                }
                this.client.out.writeObject((Object)ServerMessage.FLUSH);
                this.client.out.flush();
            }
            catch (IOException iOException) {
            }
            finally {
                this.buffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void end(ShellResponse response) {
        this.flush();
        try {
            this.client.current = null;
            this.client.out.writeObject((Object)ServerMessage.END);
            this.client.out.writeObject(response);
            this.client.out.flush();
        }
        catch (IOException iOException) {
        }
        finally {
            if (response instanceof ShellResponse.Close) {
                this.client.close();
            }
        }
    }
}

