/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import org.crsh.text.formatter.BindingRenderable;
import org.crsh.util.TypeResolver;
import org.crsh.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNDIHandler {
    public static List<BindingRenderable.BindingData> lookup(List<String> filters, String name, Boolean verbose) {
        Pattern pattern = null;
        if (name != null) {
            pattern = Pattern.compile("^" + Utils.globexToRegex(name) + "$");
        }
        ArrayList<BindingRenderable.BindingData> data = new ArrayList<BindingRenderable.BindingData>();
        data.addAll(JNDIHandler.get(filters, pattern, verbose, ""));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:/"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:comp/env/jdbc"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:jboss"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:global"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:app"));
        data.addAll(JNDIHandler.get(filters, pattern, verbose, "java:module"));
        return data;
    }

    static List<BindingRenderable.BindingData> get(List<String> filters, Pattern pattern, Boolean verbose, String path) {
        return JNDIHandler.get(filters, pattern, verbose, path, path, null);
    }

    static List<BindingRenderable.BindingData> get(List<String> filters, Pattern pattern, Boolean verbose, String path, String search, Context ctx) {
        ArrayList<BindingRenderable.BindingData> data = new ArrayList<BindingRenderable.BindingData>();
        try {
            if (ctx == null) {
                ctx = new InitialContext();
            }
            if (path.length() > 0) {
                path = path + "/";
            }
            NamingEnumeration<Binding> e = ctx.listBindings(search);
            while (e.hasMoreElements()) {
                Binding instance = e.next();
                String fullName = path + instance.getName();
                if ((filters == null || filters.size() == 0 || TypeResolver.instanceOf(instance.getObject().getClass(), filters)) && (pattern == null || pattern.matcher(fullName).find())) {
                    data.add(new BindingRenderable.BindingData(fullName, instance.getClassName(), verbose));
                }
                if (!(instance.getObject() instanceof Context)) continue;
                data.addAll(JNDIHandler.get(filters, pattern, verbose, fullName, "", (Context)instance.getObject()));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return data;
    }
}

