/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import org.crsh.cmdline.CommandDescriptor;
import org.crsh.cmdline.Description;
import org.crsh.cmdline.IllegalParameterException;
import org.crsh.cmdline.IllegalValueTypeException;
import org.crsh.cmdline.Multiplicity;
import org.crsh.cmdline.ParameterType;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.completers.EmptyCompleter;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.type.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterDescriptor<B extends TypeBinding> {
    private final B binding;
    private final Description description;
    private final ParameterType<?> type;
    private final boolean required;
    private final boolean password;
    private final Class<? extends Completer> completerType;
    private final Annotation annotation;
    private final boolean unquote;
    CommandDescriptor<?, B> owner;

    public ParameterDescriptor(B binding, ParameterType<?> type, Description description, boolean required, boolean password, boolean unquote, Class<? extends Completer> completerType, Annotation annotation) throws IllegalValueTypeException, IllegalParameterException {
        if (completerType == EmptyCompleter.class) {
            completerType = type.getValueType().getCompleter();
        }
        this.binding = binding;
        this.description = description;
        this.required = required;
        this.password = password;
        this.completerType = completerType;
        this.annotation = annotation;
        this.unquote = unquote;
        this.type = type;
    }

    public Object parse(String s) throws Exception {
        return this.type.parse(s);
    }

    public abstract Object parse(List<String> var1) throws CmdSyntaxException;

    public CommandDescriptor<?, B> getOwner() {
        return this.owner;
    }

    public Class<?> getDeclaredType() {
        return this.type.getDeclaredType();
    }

    public final B getBinding() {
        return this.binding;
    }

    public final String getUsage() {
        return this.description != null ? this.description.getUsage() : "";
    }

    public Description getDescription() {
        return this.description;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public boolean isUnquote() {
        return this.unquote;
    }

    public final boolean isPassword() {
        return this.password;
    }

    public final ValueType getType() {
        return this.type.getValueType();
    }

    public final Multiplicity getMultiplicity() {
        return this.type.getMultiplicity();
    }

    public final boolean isSingleValued() {
        return this.getMultiplicity() == Multiplicity.SINGLE;
    }

    public final boolean isMultiValued() {
        return this.getMultiplicity() == Multiplicity.MULTI;
    }

    public final Class<? extends Completer> getCompleterType() {
        return this.completerType;
    }

    public abstract void printUsage(Appendable var1) throws IOException;
}

