/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandCompletion;
import org.crsh.cmdline.Delimiter;
import org.crsh.cmdline.MethodDescriptor;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.binding.ClassFieldBinding;
import org.crsh.cmdline.binding.MethodArgumentBinding;
import org.crsh.cmdline.binding.TypeBinding;
import org.crsh.cmdline.matcher.ArgumentMatch;
import org.crsh.cmdline.matcher.ClassMatch;
import org.crsh.cmdline.matcher.CmdCompletionException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.LiteralValue;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.MethodMatch;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.impl.Completion;
import org.crsh.cmdline.matcher.impl.EmptyCompletion;
import org.crsh.cmdline.matcher.impl.Event;
import org.crsh.cmdline.matcher.impl.MethodCompletion;
import org.crsh.cmdline.matcher.impl.Mode;
import org.crsh.cmdline.matcher.impl.OptionCompletion;
import org.crsh.cmdline.matcher.impl.ParameterCompletion;
import org.crsh.cmdline.matcher.impl.Parser;
import org.crsh.cmdline.matcher.impl.SpaceCompletion;
import org.crsh.cmdline.matcher.tokenizer.Token;
import org.crsh.cmdline.matcher.tokenizer.Tokenizer;
import org.crsh.cmdline.matcher.tokenizer.TokenizerImpl;
import org.crsh.cmdline.spi.Completer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatcherImpl<T>
extends Matcher<T> {
    private final ClassDescriptor<T> descriptor;
    private final String mainName;

    public MatcherImpl(ClassDescriptor<T> descriptor) {
        this(null, descriptor);
    }

    public MatcherImpl(String mainName, ClassDescriptor<T> descriptor) {
        this.mainName = mainName;
        this.descriptor = descriptor;
    }

    private List<LiteralValue> bilto(List<? extends Token.Literal> literals) {
        ArrayList<LiteralValue> values = new ArrayList<LiteralValue>(literals.size());
        for (Token.Literal literal : literals) {
            values.add(new LiteralValue(literal.getRaw(), literal.getValue()));
        }
        return values;
    }

    @Override
    public CommandMatch<T, ?, ?> match(String name, Map<String, ?> options, List<?> arguments) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TokenizerImpl
        extends ArrayList<Token> {
            TokenizerImpl() {
            }

            int last() {
                return this.size() > 0 ? ((Token)this.get(this.size() - 1)).getTo() : 0;
            }

            @Override
            public boolean add(Token token) {
                if (this.size() > 0) {
                    super.add(new Token.Whitespace(this.last(), " "));
                }
                return super.add(token);
            }

            public void addOption(String name) {
                if (name.length() == 1) {
                    this.add(new Token.Literal.Option.Short(this.last(), "-" + name));
                } else {
                    this.add(new Token.Literal.Option.Long(this.last(), "--" + name));
                }
            }
        }
        final TokenizerImpl t = new TokenizerImpl();
        if (name != null && name.length() > 0) {
            t.add(new Token.Literal.Word(t.last(), name));
        }
        for (Map.Entry<String, ?> option : options.entrySet()) {
            if (option.getValue() instanceof Boolean) {
                if (!((Boolean)option.getValue()).booleanValue()) continue;
                t.addOption(option.getKey());
                continue;
            }
            t.addOption(option.getKey());
            t.add(new Token.Literal.Word(t.last(), option.getValue().toString()));
        }
        for (Map.Entry<String, Object> argument : arguments) {
            t.add(new Token.Literal.Word(t.last(), argument.toString()));
        }
        Tokenizer tokenizer = new Tokenizer(){
            Iterator<Token> i;
            {
                this.i = t.iterator();
            }

            protected Token parse() {
                return this.i.hasNext() ? this.i.next() : null;
            }

            public Delimiter getDelimiter() {
                return Delimiter.EMPTY;
            }
        };
        return this.match(tokenizer);
    }

    @Override
    public CommandMatch<T, ?, ?> match(String s) {
        return this.match(new TokenizerImpl(s));
    }

    private CommandMatch<T, ?, ?> match(Tokenizer tokenizer) {
        ArrayList<OptionMatch<ClassFieldBinding>> classOptions = new ArrayList<OptionMatch<ClassFieldBinding>>();
        ArrayList<ArgumentMatch<ClassFieldBinding>> classArguments = new ArrayList<ArgumentMatch<ClassFieldBinding>>();
        ArrayList<OptionMatch<MethodArgumentBinding>> methodOptions = new ArrayList<OptionMatch<MethodArgumentBinding>>();
        ArrayList<ArgumentMatch<MethodArgumentBinding>> methodArguments = new ArrayList<ArgumentMatch<MethodArgumentBinding>>();
        MethodDescriptor<Object> method = null;
        Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, this.mainName, Mode.INVOKE);
        while (true) {
            Event.Argument argumentEvent;
            List values;
            Event event;
            if ((event = parser.next()) instanceof Event.Separator) {
                continue;
            }
            if (event instanceof Event.Stop) {
                if (method != null || this.mainName == null) break;
                method = this.descriptor.getMethod(this.mainName);
                break;
            }
            if (event instanceof Event.Option) {
                Event.Option optionEvent = (Event.Option)event;
                OptionDescriptor desc = (OptionDescriptor)optionEvent.getDescriptor();
                ArrayList<OptionMatch<TypeBinding>> options = desc.getOwner() instanceof ClassDescriptor ? classOptions : methodOptions;
                boolean done = false;
                ListIterator i = options.listIterator();
                while (i.hasNext()) {
                    OptionMatch om = (OptionMatch)i.next();
                    if (!om.getParameter().equals(desc)) continue;
                    ArrayList<LiteralValue> v = new ArrayList<LiteralValue>(om.getValues());
                    v.addAll(this.bilto(optionEvent.getValues()));
                    ArrayList<String> names = new ArrayList<String>(om.getNames());
                    names.add(optionEvent.getToken().getName());
                    i.set(new OptionMatch(desc, names, v));
                    done = true;
                    break;
                }
                if (done) continue;
                options.add(new OptionMatch(desc, optionEvent.getToken().getName(), this.bilto(optionEvent.getValues())));
                continue;
            }
            if (event instanceof Event.Method) {
                method = ((Event.Method)event).getDescriptor();
                continue;
            }
            if (!(event instanceof Event.Argument) || (values = (argumentEvent = (Event.Argument)event).getValues()).size() <= 0) continue;
            ArgumentMatch match = new ArgumentMatch((ArgumentDescriptor)argumentEvent.getDescriptor(), argumentEvent.getFrom(), argumentEvent.getTo(), this.bilto(argumentEvent.getValues()));
            if (((ArgumentDescriptor)argumentEvent.getDescriptor()).getOwner() instanceof ClassDescriptor) {
                classArguments.add(match);
                continue;
            }
            methodArguments.add(match);
        }
        StringBuilder rest = new StringBuilder();
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            rest.append(token.getRaw());
        }
        ClassMatch<T> classMatch = new ClassMatch<T>(this.descriptor, classOptions, classArguments, rest.toString());
        if (method != null) {
            return new MethodMatch<T>(classMatch, method, false, methodOptions, methodArguments, rest.toString());
        }
        return classMatch;
    }

    private Completion argument(MethodDescriptor<?> method, Completer completer) {
        List arguments = method.getArguments();
        if (arguments.isEmpty()) {
            return new EmptyCompletion();
        }
        ArgumentDescriptor argument = arguments.get(0);
        return new ParameterCompletion("", Delimiter.EMPTY, argument, completer);
    }

    @Override
    public CommandCompletion complete(Completer completer, String s) throws CmdCompletionException {
        return this.getCompletion(completer, s).complete();
    }

    private Completion getCompletion(Completer completer, String s) throws CmdCompletionException {
        Event event;
        TokenizerImpl tokenizer = new TokenizerImpl(s);
        Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, this.mainName, Mode.COMPLETE);
        Event last = null;
        Event.Separator separator = null;
        MethodDescriptor<Object> method = null;
        while (true) {
            if ((event = parser.next()) instanceof Event.Separator) {
                separator = (Event.Separator)event;
                continue;
            }
            if (event instanceof Event.Stop) break;
            if (event instanceof Event.Option) {
                last = event;
                separator = null;
                continue;
            }
            if (event instanceof Event.Method) {
                method = ((Event.Method)event).getDescriptor();
                last = event;
                separator = null;
                continue;
            }
            if (!(event instanceof Event.Argument)) continue;
            last = event;
            separator = null;
        }
        Event.Stop stop = (Event.Stop)event;
        if (stop instanceof Event.Stop.Unresolved.NoSuchOption) {
            Event.Stop.Unresolved.NoSuchOption nso = (Event.Stop.Unresolved.NoSuchOption)stop;
            return new OptionCompletion(method != null ? method : this.descriptor, (Token.Literal.Option)nso.getToken());
        }
        if (stop instanceof Event.Stop.Unresolved) {
            if (stop instanceof Event.Stop.Unresolved.TooManyArguments) {
                if (method == null) {
                    Event.Stop.Unresolved.TooManyArguments tma = (Event.Stop.Unresolved.TooManyArguments)stop;
                    return new MethodCompletion<T>(this.descriptor, this.mainName, s.substring(stop.getIndex()), parser.getDelimiter());
                }
                return new EmptyCompletion();
            }
            return new EmptyCompletion();
        }
        if (stop instanceof Event.Stop.Done.Option || stop instanceof Event.Stop.Done.Arg) {
            // empty if block
        }
        if (last == null) {
            if (method == null) {
                if (((Object)this.descriptor.getSubordinates().keySet()).equals(Collections.singleton(this.mainName))) {
                    method = this.descriptor.getMethod(this.mainName);
                    List args = method.getArguments();
                    if (args.size() > 0) {
                        return new ParameterCompletion("", Delimiter.EMPTY, args.get(0), completer);
                    }
                    return new EmptyCompletion();
                }
                return new MethodCompletion<T>(this.descriptor, this.mainName, s.substring(stop.getIndex()), Delimiter.EMPTY);
            }
            return new EmptyCompletion();
        }
        if (last instanceof Event.Option) {
            Event.Option optionEvent = (Event.Option)last;
            List values = optionEvent.getValues();
            OptionDescriptor option = (OptionDescriptor)optionEvent.getDescriptor();
            if (separator == null) {
                if (values.size() == 0) {
                    return new SpaceCompletion();
                }
                if (values.size() <= option.getArity()) {
                    Token.Literal.Word word = (Token.Literal.Word)optionEvent.peekLast();
                    return new ParameterCompletion(word.getValue(), parser.getDelimiter(), option, completer);
                }
                return new EmptyCompletion();
            }
            if (values.size() < option.getArity()) {
                return new ParameterCompletion("", Delimiter.EMPTY, option, completer);
            }
            if (method == null) {
                return new MethodCompletion<T>(this.descriptor, this.mainName, s.substring(stop.getIndex()), Delimiter.EMPTY);
            }
            return this.argument(method, completer);
        }
        if (last instanceof Event.Argument) {
            Event.Argument eventArgument = (Event.Argument)last;
            ArgumentDescriptor argument = (ArgumentDescriptor)eventArgument.getDescriptor();
            if (separator != null) {
                switch (argument.getMultiplicity()) {
                    case SINGLE: {
                        List arguments = argument.getOwner().getArguments();
                        int index = arguments.indexOf(argument) + 1;
                        if (index < arguments.size()) {
                            ArgumentDescriptor nextArg = arguments.get(index);
                            return new ParameterCompletion("", Delimiter.EMPTY, nextArg, completer);
                        }
                        return new EmptyCompletion();
                    }
                    case MULTI: {
                        return new ParameterCompletion("", Delimiter.EMPTY, argument, completer);
                    }
                }
                throw new AssertionError();
            }
            Object value = eventArgument.peekLast();
            return new ParameterCompletion(((Token.Literal)value).getValue(), parser.getDelimiter(), argument, completer);
        }
        if (last instanceof Event.Method) {
            if (separator != null) {
                return this.argument(method, completer);
            }
            return new SpaceCompletion();
        }
        throw new AssertionError();
    }
}

