/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.ui;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;
import org.crsh.text.Style;
import org.crsh.text.ui.BorderStyle;
import org.crsh.text.ui.Layout;
import org.crsh.text.ui.Overflow;
import org.crsh.text.ui.RowElement;
import org.crsh.text.ui.TableElement;
import org.crsh.text.ui.TableRowReader;
import org.crsh.text.ui.TableRowRenderer;

class TableRenderer
extends Renderer {
    final Layout columnLayout;
    final Layout rowLayout;
    final BorderStyle border;
    final BorderStyle separator;
    final Overflow overflow;
    final Style.Composite style;
    final int leftCellPadding;
    final int rightCellPadding;
    private TableRowRenderer head;
    private TableRowRenderer tail;

    TableRenderer(TableElement table) {
        this.rowLayout = table.getRowLayout();
        this.columnLayout = table.getColumnLayout();
        this.border = table.getBorder();
        this.style = table.getStyle();
        this.separator = table.getSeparator();
        this.overflow = table.getOverflow();
        this.leftCellPadding = table.getLeftCellPadding();
        this.rightCellPadding = table.getRightCellPadding();
        for (RowElement row : table.getRows()) {
            if (this.head == null) {
                this.head = this.tail = new TableRowRenderer(this, row);
                continue;
            }
            this.tail = this.tail.add(new TableRowRenderer(this, row));
        }
    }

    private int getMaxColSize() {
        int n = 0;
        for (TableRowRenderer row = this.head; row != null; row = row.next()) {
            n = Math.max(n, row.getColsSize());
        }
        return n;
    }

    public int getMinWidth() {
        int minWidth = 0;
        for (TableRowRenderer row = this.head; row != null; row = row.next()) {
            minWidth = Math.max(minWidth, row.getMinWidth());
        }
        return minWidth + (this.border != null ? 2 : 0);
    }

    public int getActualWidth() {
        int actualWidth = 0;
        for (TableRowRenderer row = this.head; row != null; row = row.next()) {
            actualWidth = Math.max(actualWidth, row.getActualWidth());
        }
        return actualWidth + (this.border != null ? 2 : 0);
    }

    public int getActualHeight(int width) {
        if (this.border != null) {
            width -= 2;
        }
        int actualHeight = 0;
        for (TableRowRenderer row = this.head; row != null; row = row.next()) {
            actualHeight += row.getActualHeight(width);
        }
        if (this.border != null) {
            actualHeight += 2;
        }
        return actualHeight;
    }

    public int getMinHeight(int width) {
        return this.border != null ? 2 : 0;
    }

    public LineReader reader(int width) {
        return this.reader(width, 0);
    }

    public LineReader reader(final int width, final int height) {
        int len = this.getMaxColSize();
        int[] eltWidths = new int[len];
        int[] eltMinWidths = new int[len];
        for (TableRowRenderer row = this.head; row != null; row = row.next()) {
            for (int i = 0; i < row.getCols().size(); ++i) {
                Renderer renderable = row.getCols().get(i);
                eltWidths[i] = Math.max(eltWidths[i], renderable.getActualWidth() + row.row.leftCellPadding + row.row.rightCellPadding);
                eltMinWidths[i] = Math.max(eltMinWidths[i], renderable.getMinWidth()) + row.row.leftCellPadding + row.row.rightCellPadding;
            }
        }
        final int[] widths = this.columnLayout.compute(this.separator != null, width - (this.border != null ? 2 : 0), eltWidths, eltMinWidths);
        if (widths != null) {
            int[] heights;
            final AtomicInteger effectiveWidth = new AtomicInteger();
            if (this.border != null) {
                effectiveWidth.addAndGet(2);
            }
            for (int i = 0; i < widths.length; ++i) {
                effectiveWidth.addAndGet(widths[i]);
                if (this.separator == null || i <= 0) continue;
                effectiveWidth.addAndGet(1);
            }
            if (height > 0) {
                int size = this.tail.getSize();
                int[] actualHeights = new int[size];
                int[] minHeights = new int[size];
                for (TableRowRenderer row = this.head; row != null; row = row.next()) {
                    actualHeights[row.getIndex()] = row.getActualHeight(widths);
                    minHeights[row.getIndex()] = row.getMinHeight(widths);
                }
                heights = this.rowLayout.compute(false, height - (this.border != null ? 2 : 0), actualHeights, minHeights);
                if (heights == null) {
                    return null;
                }
            } else {
                heights = new int[this.tail.getSize()];
                Arrays.fill(heights, -1);
            }
            return new LineReader(){
                TableRowReader rHead = null;
                TableRowReader rTail = null;
                int index = 0;
                int status;
                {
                    this.status = TableRenderer.this.border != null ? 0 : 1;
                    for (TableRowRenderer row = TableRenderer.this.head; row != null && row.getIndex() < heights.length; row = row.next()) {
                        int[] what;
                        if (row.getColsSize() == widths.length) {
                            what = widths;
                        } else {
                            int end;
                            what = new int[row.getColsSize()];
                            for (int j = 0; j < widths.length; ++j) {
                                int n3 = j % what.length;
                                what[n3] = what[n3] + widths[j];
                            }
                            for (end = what.length; end > 0 && what[end - 1] == 0; --end) {
                            }
                            if (end != what.length) {
                                what = Arrays.copyOf(what, end);
                            }
                        }
                        TableRowReader next = row.renderer(what, heights[row.getIndex()]);
                        if (this.rHead == null) {
                            this.rHead = this.rTail = next;
                            continue;
                        }
                        this.rTail = this.rTail.add(next);
                    }
                }

                public boolean hasLine() {
                    switch (this.status) {
                        case 0: 
                        case 2: {
                            return true;
                        }
                        case 1: {
                            while (this.rHead != null) {
                                if (this.rHead.hasLine()) {
                                    return true;
                                }
                                this.rHead = this.rHead.next();
                            }
                            if (height > 0) {
                                if (TableRenderer.this.border == null) {
                                    if (this.index == height) {
                                        this.status = 3;
                                    }
                                } else if (this.index == height - 1) {
                                    this.status = 2;
                                }
                            } else {
                                this.status = TableRenderer.this.border != null ? 2 : 3;
                            }
                            return this.status < 3;
                        }
                    }
                    return false;
                }

                public void renderLine(RenderAppendable to) {
                    if (!this.hasLine()) {
                        throw new IllegalStateException();
                    }
                    switch (this.status) {
                        case 0: 
                        case 2: {
                            int i;
                            to.styleOff();
                            to.append(TableRenderer.this.border.corner);
                            for (i = 0; i < widths.length; ++i) {
                                if (widths[i] <= 0) continue;
                                if (TableRenderer.this.separator != null && i > 0) {
                                    to.append(TableRenderer.this.border.horizontal);
                                }
                                for (int j = 0; j < widths[i]; ++j) {
                                    to.append(TableRenderer.this.border.horizontal);
                                }
                            }
                            to.append(TableRenderer.this.border.corner);
                            to.styleOn();
                            for (i = width - effectiveWidth.get(); i > 0; --i) {
                                to.append(' ');
                            }
                            ++this.status;
                            break;
                        }
                        case 1: {
                            int i;
                            boolean sep;
                            boolean bl = sep = this.rHead != null && this.rHead.isSeparator();
                            if (TableRenderer.this.border != null) {
                                to.styleOff();
                                to.append(sep ? TableRenderer.this.border.corner : TableRenderer.this.border.vertical);
                                to.styleOn();
                            }
                            if (TableRenderer.this.style != null) {
                                to.enterStyle(TableRenderer.this.style);
                            }
                            if (this.rHead != null) {
                                this.rHead.renderLine(to);
                            } else {
                                for (i = 0; i < widths.length; ++i) {
                                    if (TableRenderer.this.separator != null && i > 0) {
                                        to.append(TableRenderer.this.separator.vertical);
                                    }
                                    for (int j = 0; j < widths[i]; ++j) {
                                        to.append(' ');
                                    }
                                }
                            }
                            if (TableRenderer.this.style != null) {
                                to.leaveStyle();
                            }
                            if (TableRenderer.this.border != null) {
                                to.styleOff();
                                to.append(sep ? TableRenderer.this.border.corner : TableRenderer.this.border.vertical);
                                to.styleOn();
                            }
                            for (i = width - effectiveWidth.get(); i > 0; --i) {
                                to.append(' ');
                            }
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    ++this.index;
                }
            };
        }
        return Renderer.NULL.reader(width);
    }
}

