/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.completion;

import java.util.Set;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.Completion;
import org.crsh.cli.impl.completion.CompletionException;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.impl.tokenizer.Token;
import org.crsh.cli.spi.Completion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptionCompletion<T>
extends Completion {
    private final CommandDescriptor<T> descriptor;
    private final Token.Literal.Option prefix;

    public OptionCompletion(CommandDescriptor<T> descriptor, Token.Literal.Option prefix) {
        this.descriptor = descriptor;
        this.prefix = prefix;
    }

    @Override
    public CompletionMatch complete() throws CompletionException {
        Completion.Builder builder = org.crsh.cli.spi.Completion.builder(this.prefix.getValue());
        Set<String> optionNames = this.prefix instanceof Token.Literal.Option.Short ? this.descriptor.getShortOptionNames() : this.descriptor.getLongOptionNames();
        for (String optionName : optionNames) {
            if (!optionName.startsWith(this.prefix.getValue())) continue;
            builder.add(optionName.substring(this.prefix.getValue().length()), true);
        }
        return new CompletionMatch(Delimiter.EMPTY, builder.build());
    }
}

