/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term.inline;

import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.ssh.term.SSHContext;
import org.crsh.text.Chunk;
import org.crsh.text.Text;

public class SSHInlineShellProcessContext
implements ShellProcessContext {
    private static final String MSG = "Cannot determine tty width : you should force pseudo-tty allocation (-t option)";
    private boolean msgDone;
    private ShellResponse response;
    private final CountDownLatch latch;
    private final SSHContext context;
    private final ShellProcess process;
    private final PrintStream out;
    private final PrintStream err;

    SSHInlineShellProcessContext(SSHContext context, ShellProcess process, PrintStream out, PrintStream err) {
        this.out = out;
        this.context = context;
        this.process = process;
        this.latch = new CountDownLatch(1);
        this.response = null;
        this.err = err;
        this.msgDone = false;
    }

    public SSHInlineShellProcessContext execute() {
        this.process.execute((ShellProcessContext)this);
        return this;
    }

    public boolean takeAlternateBuffer() {
        return false;
    }

    public boolean releaseAlternateBuffer() {
        return false;
    }

    public int getWidth() {
        int width = this.context.getWidth();
        if (width == -1 && !this.msgDone) {
            this.msgDone = true;
            this.out.print(MSG);
            this.out.flush();
        }
        return width;
    }

    public int getHeight() {
        int height = this.context.getHeight();
        if (height == -1 && !this.msgDone) {
            this.msgDone = true;
            this.out.print(MSG);
            this.out.flush();
        }
        return height;
    }

    public String getProperty(String name) {
        return this.context.getProperty(name);
    }

    public String readLine(String msg, boolean echo) {
        return null;
    }

    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    public void provide(Chunk element) throws IOException {
        CharSequence seq;
        int length;
        if (element instanceof Text && (length = (seq = ((Text)element).getText()).length()) > 0) {
            for (int i = 0; i < length; ++i) {
                char c = seq.charAt(i);
                if (c == '\r') continue;
                if (c == '\n') {
                    this.out.print("\r\n");
                    continue;
                }
                this.out.print(c);
            }
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void end(ShellResponse response) {
        this.response = response;
        this.latch.countDown();
    }

    ShellResponse getResponse() {
        try {
            this.latch.await();
            return this.response;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

