/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.terminal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.wimpi.telnetd.BootException;
import net.wimpi.telnetd.io.terminal.Terminal;
import net.wimpi.telnetd.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TerminalManager {
    private static Log log = LogFactory.getLog(TerminalManager.class);
    private static TerminalManager c_Self;
    private HashMap terminals;
    private boolean m_WindoofHack = false;

    private TerminalManager() {
        c_Self = this;
        this.terminals = new HashMap(25);
    }

    private TerminalManager(Map terminals) {
        this();
        this.terminals = new HashMap(terminals);
    }

    public Terminal getTerminal(String key) {
        Terminal term = null;
        try {
            term = key.equals("ANSI") && this.m_WindoofHack ? (Terminal)this.terminals.get("windoof") : (!this.terminals.containsKey(key = key.toLowerCase()) ? (Terminal)this.terminals.get("default") : (Terminal)this.terminals.get(key));
        }
        catch (Exception e) {
            log.error((Object)"getTerminal()", (Throwable)e);
        }
        return term;
    }

    public String[] getAvailableTerminals() {
        String[] tn = new String[this.terminals.size()];
        int i = 0;
        Iterator iter = this.terminals.keySet().iterator();
        while (iter.hasNext()) {
            tn[i] = (String)iter.next();
            ++i;
        }
        return tn;
    }

    public void setWindoofHack(boolean b) {
        this.m_WindoofHack = b;
    }

    private void setupTerminals(HashMap terminalsMap) {
        String termname = "";
        String termclass = "";
        Terminal term = null;
        Object[] entry = null;
        Iterator iter = terminalsMap.keySet().iterator();
        while (iter.hasNext()) {
            try {
                termname = (String)iter.next();
                entry = (Object[])terminalsMap.get(termname);
                termclass = (String)entry[0];
                log.debug((Object)("Preparing terminal [" + termname + "] " + termclass));
                term = (Terminal)Class.forName(termclass).newInstance();
                this.terminals.put(termname, term);
                String[] aliases = (String[])entry[1];
                for (int i = 0; i < aliases.length; ++i) {
                    if (this.terminals.containsKey(aliases[i])) continue;
                    this.terminals.put(aliases[i], term);
                }
            }
            catch (Exception e) {
                log.error((Object)"setupTerminals()", (Throwable)e);
            }
        }
        log.debug((Object)"Terminals:");
        for (String tn : this.terminals.keySet()) {
            log.debug((Object)(tn + "=" + this.terminals.get(tn)));
        }
    }

    public static TerminalManager createTerminalManager(Properties settings) throws BootException {
        HashMap<String, Object[]> terminals = new HashMap<String, Object[]>(20);
        boolean defaultFlag = false;
        TerminalManager tmgr = new TerminalManager();
        try {
            log.debug((Object)"Creating terminal manager.....");
            boolean winhack = new Boolean(settings.getProperty("terminals.windoof"));
            String terms = settings.getProperty("terminals");
            if (terms == null) {
                log.debug((Object)"No terminals declared.");
                throw new BootException("No terminals declared.");
            }
            String[] tn = StringUtil.split(terms, ",");
            Object[] entry = null;
            String[] aliases = null;
            for (int i = 0; i < tn.length; ++i) {
                entry = new Object[2];
                entry[0] = settings.getProperty("term." + tn[i] + ".class");
                aliases = StringUtil.split(settings.getProperty("term." + tn[i] + ".aliases"), ",");
                for (int n = 0; n < aliases.length; ++n) {
                    if (!aliases[n].equalsIgnoreCase("default")) continue;
                    if (!defaultFlag) {
                        defaultFlag = true;
                        continue;
                    }
                    throw new BootException("Only one default can be declared.");
                }
                entry[1] = aliases;
                terminals.put(tn[i], entry);
            }
            if (!defaultFlag) {
                throw new BootException("No default terminal declared.");
            }
            tmgr = new TerminalManager();
            tmgr.setWindoofHack(winhack);
            tmgr.setupTerminals(terminals);
            return tmgr;
        }
        catch (Exception ex) {
            log.error((Object)"createManager()", (Throwable)ex);
            throw new BootException("Creating TerminalManager Instance failed:\n" + ex.getMessage());
        }
    }

    public static TerminalManager createTerminalManager(Map terminals, boolean winhack) throws BootException {
        if (!terminals.containsKey("default")) {
            throw new BootException("No default terminal declared.");
        }
        TerminalManager tmgr = new TerminalManager(terminals);
        tmgr.setWindoofHack(winhack);
        return tmgr;
    }

    public static TerminalManager getReference() {
        return c_Self;
    }

    public HashMap getTerminals() {
        return this.terminals;
    }

    public void setTerminals(HashMap terminals) {
        this.terminals = terminals;
    }
}

