/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.auth.gss;

import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.server.HandshakingUserAuth;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.MessageProp;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAuthGSS
implements HandshakingUserAuth {
    public static final Oid KRB5_MECH = UserAuthGSS.createOID("1.2.840.113554.1.2.2");
    public static final Oid KRB5_NT_PRINCIPAL = UserAuthGSS.createOID("1.2.840.113554.1.2.2.1");
    private String servicePrincipalName;
    private String keytabFile;
    private GSSContext ctxt;
    private GSSCredential creds;
    private String user;
    private String service;
    private String identity;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public Boolean auth(ServerSession sess, String user, Buffer buff) throws Exception {
        GSSAuthenticator auth = this.getAuthenticator(sess);
        this.user = user;
        int num = buff.getInt();
        for (int i = 0; i < num; ++i) {
            Oid oid = new Oid(buff.getBytes());
            if (!oid.equals(KRB5_MECH)) continue;
            this.log.debug("UserAuthGSS: found Kerberos 5");
            if (!auth.validateInitialUser(sess, user)) {
                return Boolean.FALSE;
            }
            GSSManager mgr = auth.getGSSManager();
            GSSCredential creds = auth.getGSSCredential(mgr);
            if (creds == null) {
                return Boolean.FALSE;
            }
            this.ctxt = mgr.createContext(creds);
            Buffer b = sess.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_INFO_REQUEST, 0);
            byte[] out = oid.getDER();
            b.putBytes(out);
            sess.writePacket(b);
            return null;
        }
        return Boolean.FALSE;
    }

    public void setServiceName(String service) {
        this.service = service;
    }

    public boolean handles(SshConstants.Message msg) {
        return msg == SshConstants.Message.SSH_MSG_USERAUTH_INFO_RESPONSE || msg == SshConstants.Message.SSH_MSG_USERAUTH_GSSAPI_MIC && this.ctxt.isEstablished();
    }

    public Boolean next(ServerSession session, SshConstants.Message msg, Buffer buffer) throws Exception {
        GSSAuthenticator auth = this.getAuthenticator(session);
        this.log.debug("In krb5.next: msg = " + (Object)((Object)msg));
        if (this.ctxt.isEstablished()) {
            if (msg != SshConstants.Message.SSH_MSG_USERAUTH_GSSAPI_MIC) {
                return Boolean.FALSE;
            }
            Buffer msgbuf = new Buffer();
            msgbuf.putString(session.getSessionId());
            msgbuf.putByte(SshConstants.Message.SSH_MSG_USERAUTH_REQUEST.toByte());
            msgbuf.putString(this.user.getBytes("UTF-8"));
            msgbuf.putString(this.service);
            msgbuf.putString("gssapi-with-mic");
            byte[] msgbytes = msgbuf.getCompactData();
            byte[] inmic = buffer.getBytes();
            try {
                this.ctxt.verifyMIC(inmic, 0, inmic.length, msgbytes, 0, msgbytes.length, new MessageProp(false));
                this.log.debug("MIC verified");
                return Boolean.TRUE;
            }
            catch (GSSException e) {
                this.log.info("GSS verification error: {}", (Object)e.toString());
                return Boolean.FALSE;
            }
        }
        byte[] tok = buffer.getBytes();
        byte[] out = this.ctxt.acceptSecContext(tok, 0, tok.length);
        boolean established = this.ctxt.isEstablished();
        if (established && this.identity == null) {
            this.identity = ((Object)this.ctxt.getSrcName()).toString();
            this.log.info("GSS identity is {}", (Object)this.identity);
            if (!auth.validateIdentity(session, this.identity)) {
                return Boolean.FALSE;
            }
        }
        if (out != null && out.length > 0) {
            Buffer b = session.createBuffer(SshConstants.Message.SSH_MSG_USERAUTH_INFO_RESPONSE, 0);
            b.putBytes(out);
            session.writePacket(b);
            return null;
        }
        return established;
    }

    public String getUserName() throws GSSException {
        return this.identity;
    }

    public void destroy() {
        if (this.creds != null) {
            try {
                this.creds.dispose();
            }
            catch (GSSException e) {
                // empty catch block
            }
            if (this.ctxt != null) {
                try {
                    this.ctxt.dispose();
                }
                catch (GSSException gSSException) {
                    // empty catch block
                }
            }
        }
    }

    private GSSAuthenticator getAuthenticator(ServerSession session) throws Exception {
        GSSAuthenticator ga = session.getServerFactoryManager().getGSSAuthenticator();
        if (ga == null) {
            throw new Exception("No GSSAuthenticator configured");
        }
        return ga;
    }

    private static Oid createOID(String rep) {
        try {
            return new Oid(rep);
        }
        catch (GSSException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements NamedFactory<UserAuth> {
        @Override
        public String getName() {
            return "gssapi-with-mic";
        }

        @Override
        public UserAuth create() {
            return new UserAuthGSS();
        }
    }
}

