/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.text.formatter;

import java.lang.management.MemoryUsage;
import org.crsh.text.Color;
import org.crsh.text.LineReader;
import org.crsh.text.RenderAppendable;
import org.crsh.text.Renderer;

public class MemoryUsageRenderer
extends Renderer {
    private final MemoryUsage usage;

    public MemoryUsageRenderer(MemoryUsage usage) {
        this.usage = usage;
    }

    @Override
    public int getActualWidth() {
        return 32;
    }

    @Override
    public int getMinWidth() {
        return 4;
    }

    @Override
    public int getMinHeight(int width) {
        return 1;
    }

    @Override
    public int getActualHeight(int width) {
        return 2;
    }

    @Override
    public LineReader reader(int width) {
        return this.reader(width, 2);
    }

    @Override
    public LineReader reader(final int width, final int height) {
        return new LineReader(){
            private int index = 0;

            @Override
            public boolean hasLine() {
                return this.index < height;
            }

            @Override
            public void renderLine(RenderAppendable to) throws IllegalStateException {
                if (!this.hasLine()) {
                    throw new IllegalStateException();
                }
                long range = MemoryUsageRenderer.this.usage.getMax() - MemoryUsageRenderer.this.usage.getInit();
                Color previous = null;
                if (MemoryUsageRenderer.this.usage.getMax() > 0L) {
                    long a = (long)width * MemoryUsageRenderer.this.usage.getUsed() / MemoryUsageRenderer.this.usage.getMax();
                    long b = (long)width * MemoryUsageRenderer.this.usage.getCommitted() / MemoryUsageRenderer.this.usage.getMax();
                    for (int i = 0; i < width; ++i) {
                        Color current = (long)i >= b ? Color.green : ((long)i >= a ? Color.blue : Color.cyan);
                        if (previous != current) {
                            if (previous != null) {
                                to.leaveStyle();
                            }
                            to.enterStyle(current.bg());
                            previous = current;
                        }
                        to.append(' ');
                    }
                    if (previous != null) {
                        to.leaveStyle();
                    }
                } else {
                    for (int i = 0; i < width; ++i) {
                        to.append(' ');
                    }
                }
                ++this.index;
            }
        };
    }
}

