/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.util.ServletContextMap;
import org.crsh.vfs.FS;
import org.crsh.vfs.spi.servlet.ServletContextDriver;

public class WebPluginLifeCycle
extends PluginLifeCycle
implements ServletContextListener {
    private static final Object lock = new Object();
    private static final Map<String, PluginContext> contextMap = new HashMap<String, PluginContext>();
    private boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginContext getPluginContext(ServletContext sc) throws NullPointerException {
        String contextPath = sc.getContextPath();
        Object object = lock;
        synchronized (object) {
            return contextMap.get(contextPath);
        }
    }

    protected PluginDiscovery createDiscovery(ServletContext context, ClassLoader classLoader) {
        return new ServiceLoaderDiscovery(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        String contextPath = context.getContextPath();
        this.setConfig(System.getProperties());
        Object object = lock;
        synchronized (object) {
            if (!contextMap.containsKey(contextPath)) {
                FS cmdFS = this.createCommandFS(context);
                FS confFS = this.createConfFS(context);
                ClassLoader webAppLoader = Thread.currentThread().getContextClassLoader();
                PluginContext pluginContext = new PluginContext(this.createDiscovery(context, webAppLoader), new ServletContextMap(context), cmdFS, confFS, webAppLoader);
                contextMap.put(contextPath, pluginContext);
                this.registered = true;
                this.start(pluginContext);
            }
        }
    }

    protected FS createCommandFS(ServletContext context) {
        return new FS().mount(new ServletContextDriver(context, "/WEB-INF/crash/commands/"));
    }

    protected FS createConfFS(ServletContext context) {
        return new FS().mount(new ServletContextDriver(context, "/WEB-INF/crash/"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent sce) {
        if (this.registered) {
            ServletContext sc = sce.getServletContext();
            String contextPath = sc.getContextPath();
            Object object = lock;
            synchronized (object) {
                contextMap.remove(contextPath);
                this.registered = false;
                this.stop();
            }
        }
    }
}

