/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.standalone;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginLifeCycle;
import org.crsh.plugin.ServiceLoaderDiscovery;
import org.crsh.vfs.FS;
import org.crsh.vfs.Path;
import org.crsh.vfs.spi.FSDriver;

public class Bootstrap
extends PluginLifeCycle {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final FS confFS = new FS();
    private final FS cmdFS = new FS();
    private final ClassLoader loader;
    private Map<String, Object> attributes;

    public Bootstrap(ClassLoader baseLoader) throws NullPointerException {
        if (baseLoader == null) {
            throw new NullPointerException("No null base loader accepted");
        }
        this.attributes = Collections.emptyMap();
        this.loader = new URLClassLoader(new URL[0], baseLoader);
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public Bootstrap addToConfPath(FSDriver<?> driver) throws NullPointerException {
        if (driver == null) {
            throw new NullPointerException("No null conf driver");
        }
        this.log.info("Added " + driver + " driver to conf path");
        this.confFS.mount(driver);
        return this;
    }

    public Bootstrap addToConfPath(File path) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null conf path");
        }
        this.log.info("Added " + path.getCanonicalPath() + " file to conf path");
        this.confFS.mount(path);
        return this;
    }

    public Bootstrap addToConfPath(Path path) throws NullPointerException, IOException, URISyntaxException {
        if (path == null) {
            throw new NullPointerException("No null conf path");
        }
        this.log.info("Added " + path.getValue() + " path to conf path");
        this.confFS.mount(this.loader, path);
        return this;
    }

    public Bootstrap addToCmdPath(FSDriver<?> driver) throws NullPointerException {
        if (driver == null) {
            throw new NullPointerException("No null conf driver");
        }
        this.log.info("Added " + driver + " driver to command path");
        this.cmdFS.mount(driver);
        return this;
    }

    public Bootstrap addToCmdPath(File path) throws NullPointerException, IOException {
        if (path == null) {
            throw new NullPointerException("No null command path");
        }
        this.log.info("Added " + path.getAbsolutePath() + " file to command path");
        this.cmdFS.mount(path);
        return this;
    }

    public Bootstrap addToCmdPath(Path path) throws NullPointerException, IOException, URISyntaxException {
        if (path == null) {
            throw new NullPointerException("No null command path");
        }
        this.log.info("Added " + path.getValue() + " path to command path");
        this.cmdFS.mount(this.loader, path);
        return this;
    }

    public void bootstrap() throws Exception {
        ServiceLoaderDiscovery discovery = new ServiceLoaderDiscovery(this.loader);
        PluginContext context = new PluginContext(discovery, this.attributes, this.cmdFS, this.confFS, this.loader);
        context.refresh();
        this.start(context);
    }

    public void shutdown() {
        this.stop();
    }
}

