/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.wimpi.telnetd.io.terminal.TerminalManager;
import net.wimpi.telnetd.net.Connection;
import net.wimpi.telnetd.net.ConnectionManager;
import net.wimpi.telnetd.net.PortListener;
import net.wimpi.telnetd.shell.ShellManager;
import net.wimpi.telnetd.util.StringUtil;
import org.crsh.plugin.PluginContext;
import org.crsh.term.TermLifeCycle;
import org.crsh.vfs.Resource;

public class TelnetLifeCycle
extends TermLifeCycle {
    private final Logger log = Logger.getLogger(TelnetLifeCycle.class.getName());
    private Integer port;
    private List<PortListener> listeners;
    private static final ConcurrentHashMap<ConnectionManager, TelnetLifeCycle> map = new ConcurrentHashMap();
    private Resource config;

    static TelnetLifeCycle getLifeCycle(Connection conn) {
        return map.get(conn.getConnectionData().getManager());
    }

    public TelnetLifeCycle(PluginContext context) {
        super(context);
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Resource getConfig() {
        return this.config;
    }

    public void setConfig(Resource config) {
        this.config = config;
    }

    protected synchronized void doInit() throws Exception {
        String[] listnames;
        Properties props = new Properties();
        props.load(new ByteArrayInputStream(this.config.getContent()));
        if (this.port != null) {
            this.log.log(Level.FINE, "Explicit telnet port configuration with value " + this.port);
            props.put("std.port", this.port.toString());
        } else {
            this.log.log(Level.FINE, "Use default telnet port configuration " + props.getProperty("std.port"));
        }
        ShellManager.createShellManager((Properties)props);
        TerminalManager.createTerminalManager((Properties)props);
        ArrayList<PortListener> listeners = new ArrayList<PortListener>();
        for (String listname : listnames = StringUtil.split((String)props.getProperty("listeners"), (String)",")) {
            PortListener listener = PortListener.createPortListener((String)listname, (Properties)props);
            listeners.add(listener);
        }
        this.listeners = listeners;
        for (PortListener listener : this.listeners) {
            listener.start();
            map.put(listener.getConnectionManager(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doDestroy() {
        this.log.log(Level.INFO, "Destroying telnet life cycle");
        if (this.listeners != null) {
            List<PortListener> listeners = this.listeners;
            this.listeners = null;
            for (PortListener listener : listeners) {
                try {
                    listener.stop();
                }
                catch (Exception ignore) {}
                continue;
                finally {
                    map.remove(listener.getConnectionManager());
                }
            }
        }
    }
}

