/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    static final Pattern INDENT_PATTERN = Pattern.compile("(?<=^|\\n)[ \\t\\x0B\\f\\r]*(?=\\S)");
    public static final String MAN_TAB = Util._tab(7);
    public static final String MAN_TAB_EXTRA = Util._tab(11);
    static final String[] tabIndex;

    static String tab(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        if (size < tabIndex.length) {
            return tabIndex[size];
        }
        return Util._tab(size);
    }

    private static String _tab(int size) {
        char[] tmp = new char[size];
        Arrays.fill(tmp, ' ');
        return new String(tmp);
    }

    public static <A extends Appendable> A indent(int tab, CharSequence s, A appendable) throws IOException {
        return Util.indent(Util.tab(tab), s, appendable);
    }

    public static <A extends Appendable> A indent(String tab, CharSequence s, A appendable) throws IOException {
        Matcher matcher = INDENT_PATTERN.matcher(s);
        int prev = 0;
        while (matcher.find()) {
            int start = matcher.start();
            appendable.append(s, prev, start);
            appendable.append(tab);
            prev = matcher.end();
        }
        appendable.append(s, prev, s.length());
        return appendable;
    }

    public static <T> Iterable<T[]> tuples(final Class<T> type, final Iterable<? extends T> ... iterables) {
        return new Iterable<T[]>(){

            @Override
            public Iterator<T[]> iterator() {
                return new Iterator<T[]>(){
                    private final Iterator<?>[] iterators;
                    private T[] next;
                    {
                        this.iterators = new Iterator[iterables.length];
                        for (int i = 0; i < iterables.length; ++i) {
                            this.iterators[i] = iterables[i].iterator();
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            Object[] tuple = (Object[])Array.newInstance(type, 2);
                            for (int i = 0; i < this.iterators.length; ++i) {
                                Iterator<?> iterator = this.iterators[i];
                                if (!iterator.hasNext()) {
                                    return false;
                                }
                                tuple[i] = type.cast(iterator.next());
                            }
                            this.next = tuple;
                        }
                        return true;
                    }

                    @Override
                    public T[] next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        T[] tmp = this.next;
                        this.next = null;
                        return tmp;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static <T> Iterable<? extends T> join(final Iterable<? extends T> ... iterables) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int index;
                    Iterator<? extends T> current;
                    T next;

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            while (!(this.current != null && this.current.hasNext() || this.index >= iterables.length)) {
                                this.current = iterables[this.index++].iterator();
                            }
                            if (this.current != null && this.current.hasNext()) {
                                this.next = this.current.next();
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Object tmp = this.next;
                        this.next = null;
                        return tmp;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static {
        String[] tmp = new String[20];
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = Util._tab(i);
        }
        tabIndex = tmp;
    }
}

