/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.io.IOException;
import java.util.Map;
import org.crsh.command.CommandContext;
import org.crsh.command.ScriptException;
import org.crsh.io.Filter;
import org.crsh.shell.ScreenContext;
import org.crsh.text.Chunk;
import org.crsh.text.ChunkAdapter;
import org.crsh.util.Safe;

abstract class PipeFilter<C, P>
implements Filter<C, P, CommandContext<P>>,
CommandContext<C> {
    protected CommandContext<P> context;
    protected final boolean piped;

    protected PipeFilter(boolean piped) {
        this.piped = piped;
    }

    @Override
    public final boolean isPiped() {
        return this.piped;
    }

    @Override
    public final boolean takeAlternateBuffer() throws IOException {
        return this.context.takeAlternateBuffer();
    }

    @Override
    public final boolean releaseAlternateBuffer() throws IOException {
        return this.context.releaseAlternateBuffer();
    }

    @Override
    public final String getProperty(String propertyName) {
        return this.context.getProperty(propertyName);
    }

    @Override
    public final String readLine(String msg, boolean echo) {
        return this.context.readLine(msg, echo);
    }

    @Override
    public final int getWidth() {
        return this.context.getWidth();
    }

    @Override
    public final int getHeight() {
        return this.context.getHeight();
    }

    @Override
    public Map<String, Object> getSession() {
        return this.context.getSession();
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.context.getAttributes();
    }

    static class Sink<P>
    extends PipeFilter<Object, P> {
        private final Class<P> producedType;

        Sink(Class<P> producedType, boolean piped) {
            super(piped);
            this.producedType = producedType;
        }

        @Override
        public Class<P> getProducedType() {
            return this.producedType;
        }

        @Override
        public void open(CommandContext<P> consumer) {
            this.context = consumer;
        }

        @Override
        public void provide(Object element) throws IOException {
        }

        @Override
        public Class<Object> getConsumedType() {
            return Object.class;
        }

        @Override
        public void flush() throws IOException {
            this.context.flush();
        }

        @Override
        public void close() throws IOException {
            this.context.close();
        }
    }

    static class Chunkizer
    extends PipeFilter<Object, Chunk> {
        private ChunkAdapter ca;

        Chunkizer(boolean piped) {
            super(piped);
        }

        @Override
        public Class<Chunk> getProducedType() {
            return Chunk.class;
        }

        @Override
        public Class<Object> getConsumedType() {
            return Object.class;
        }

        @Override
        public void open(final CommandContext<Chunk> consumer) {
            this.ca = new ChunkAdapter(new ScreenContext<Chunk>(){

                @Override
                public int getWidth() {
                    return consumer.getWidth();
                }

                @Override
                public int getHeight() {
                    return consumer.getHeight();
                }

                @Override
                public Class<Chunk> getConsumedType() {
                    return Chunk.class;
                }

                @Override
                public void provide(Chunk element) throws IOException {
                    Chunkizer.this.context.provide(element);
                }

                @Override
                public void flush() throws IOException {
                    Chunkizer.this.context.flush();
                }
            });
            this.context = consumer;
        }

        @Override
        public void provide(Object element) throws ScriptException, IOException {
            this.ca.provide(element);
        }

        @Override
        public void flush() throws ScriptException, IOException {
            this.ca.flush();
        }

        @Override
        public void close() throws ScriptException, IOException {
            this.context.close();
        }
    }

    static class Noop<P>
    extends PipeFilter<P, P> {
        Noop(boolean piped) {
            super(piped);
        }

        @Override
        public void provide(P element) throws IOException {
            this.context.provide(element);
        }

        @Override
        public Class<P> getConsumedType() {
            return this.context.getConsumedType();
        }

        @Override
        public void flush() throws IOException {
            this.context.flush();
        }

        @Override
        public Class<P> getProducedType() {
            return this.context.getConsumedType();
        }

        @Override
        public void open(CommandContext<P> consumer) {
            this.context = consumer;
        }

        @Override
        public void close() {
            Safe.close(this.context);
        }
    }
}

