/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.plugin;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginDiscovery;
import org.crsh.plugin.PluginManager;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.PropertyManager;
import org.crsh.plugin.ResourceKind;
import org.crsh.plugin.ResourceManager;
import org.crsh.vfs.FS;
import org.crsh.vfs.Resource;

public final class PluginContext {
    private static final Logger log = Logger.getLogger(PluginContext.class.getName());
    final PluginManager manager;
    private final ClassLoader loader;
    private final String version;
    private final ScheduledExecutorService scanner;
    private final Map<String, Object> attributes;
    private final ExecutorService executor;
    private boolean started;
    private ScheduledFuture scannerFuture;
    private final ResourceManager resourceManager;
    private final PropertyManager propertyManager;

    public PluginContext(PluginDiscovery discovery, Map<String, Object> attributes, FS cmdFS, FS confFS, ClassLoader loader) throws NullPointerException {
        this(Executors.newFixedThreadPool(20), new ScheduledThreadPoolExecutor(1), discovery, attributes, cmdFS, confFS, loader);
    }

    public PluginContext(ExecutorService executor, ScheduledExecutorService scanner, PluginDiscovery discovery, Map<String, Object> attributes, FS cmdFS, FS confFS, ClassLoader loader) throws NullPointerException {
        if (executor == null) {
            throw new NullPointerException("No null executor accepted");
        }
        if (scanner == null) {
            throw new NullPointerException("No null scanner accepted");
        }
        if (discovery == null) {
            throw new NullPointerException("No null plugin discovery accepted");
        }
        if (confFS == null) {
            throw new NullPointerException("No null configuration file system accepted");
        }
        if (cmdFS == null) {
            throw new NullPointerException("No null command file system accepted");
        }
        if (loader == null) {
            throw new NullPointerException("No null loader accepted");
        }
        if (attributes == null) {
            throw new NullPointerException("No null attributes accepted");
        }
        String version = null;
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.crsh/crsh.shell.core/pom.properties");
            if (in != null) {
                props.load(in);
                version = props.getProperty("version");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Could not load maven properties", e);
        }
        if (version == null) {
            log.log(Level.WARNING, "No version found will use unknown value instead");
            version = "unknown";
        }
        this.loader = loader;
        this.attributes = attributes;
        this.version = version;
        this.started = false;
        this.manager = new PluginManager(this, discovery);
        this.executor = executor;
        this.scanner = scanner;
        this.resourceManager = new ResourceManager(cmdFS, confFS);
        this.propertyManager = new PropertyManager();
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public <T> T getProperty(PropertyDescriptor<T> desc) throws NullPointerException {
        return this.propertyManager.resolvePropertyValue(desc);
    }

    public <T> T getProperty(String propertyName, Class<T> type) throws NullPointerException {
        return this.propertyManager.resolvePropertyValue(propertyName, type);
    }

    public <T> void setProperty(PropertyDescriptor<T> desc, T value) throws NullPointerException {
        this.propertyManager.setProperty(desc, value);
    }

    public <T> void setProperty(PropertyDescriptor<T> desc, String value) throws NullPointerException, IllegalArgumentException {
        this.propertyManager.parseProperty(desc, value);
    }

    public Resource loadResource(String resourceId, ResourceKind resourceKind) {
        return this.resourceManager.loadResource(resourceId, resourceKind);
    }

    public List<String> listResourceId(ResourceKind kind) {
        return this.resourceManager.listResourceId(kind);
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public Iterable<CRaSHPlugin<?>> getPlugins() {
        return this.manager.getPlugins();
    }

    public <T> Iterable<T> getPlugins(Class<T> pluginType) {
        return this.manager.getPlugins(pluginType);
    }

    public <T> T getPlugin(Class<T> pluginType) {
        Iterator<T> plugins = this.manager.getPlugins(pluginType).iterator();
        return plugins.hasNext() ? (T)plugins.next() : null;
    }

    public void refresh() {
        this.resourceManager.refresh();
    }

    synchronized void start() {
        if (!this.started) {
            Integer refreshRate = this.getProperty(PropertyDescriptor.VFS_REFRESH_PERIOD);
            TimeUnit timeUnit = this.getProperty(PropertyDescriptor.VFS_REFRESH_UNIT);
            if (refreshRate != null && refreshRate > 0) {
                TimeUnit tu = timeUnit != null ? timeUnit : TimeUnit.SECONDS;
                this.scannerFuture = this.scanner.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        PluginContext.this.refresh();
                    }
                }, 0L, refreshRate.intValue(), tu);
            }
            this.manager.getPlugins(Object.class);
            this.started = true;
        } else {
            log.log(Level.WARNING, "Attempt to double start");
        }
    }

    synchronized void stop() {
        if (this.started) {
            this.manager.shutdown();
            if (this.scannerFuture != null) {
                this.scannerFuture.cancel(true);
            }
            this.scanner.shutdownNow();
            this.executor.shutdownNow();
        } else {
            log.log(Level.WARNING, "Attempt to stop when stopped");
        }
    }
}

