/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.command.pipeline;

import java.io.IOException;
import org.crsh.command.CommandContext;
import org.crsh.command.pipeline.AbstractPipe;
import org.crsh.text.Chunk;

public class ConvertingPipe<C, P, CONS extends CommandContext<? super P>>
extends AbstractPipe<C, P, CONS> {
    private final Class<C> consumedType;
    private final Class<P> producedType;

    public ConvertingPipe(Class<C> consumedType, Class<P> producedType, boolean piped) {
        super(piped);
        this.consumedType = consumedType;
        this.producedType = producedType;
    }

    @Override
    public Class<C> getConsumedType() {
        return this.consumedType;
    }

    @Override
    public Class<P> getProducedType() {
        return this.producedType;
    }

    @Override
    public void write(Chunk chunk) throws IOException {
        if (!this.producedType.equals(Void.class)) {
            if (this.producedType.isAssignableFrom(Chunk.class)) {
                P p = this.producedType.cast(chunk);
                this.consumer.provide(p);
            } else {
                this.consumer.write(chunk);
            }
        }
    }

    @Override
    public void provide(C element) throws IOException {
        if (this.producedType.isInstance(element)) {
            P p = this.producedType.cast(element);
            this.consumer.provide(p);
        }
    }
}

