/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.lang.groovy.closure;

import groovy.lang.Closure;
import java.io.IOException;
import org.crsh.command.CommandContext;
import org.crsh.command.CommandInvoker;
import org.crsh.lang.groovy.closure.ClosureDelegate;

public class ClosureInvoker
extends CommandInvoker<Object, Object> {
    private final Closure closure;
    private final Class<?> type;
    private CommandContext<? super Object> consumer;

    public ClosureInvoker(Closure closure) {
        Class[] parameterTypes = closure.getParameterTypes();
        Class type = parameterTypes != null && parameterTypes.length > 0 ? parameterTypes[0] : Object.class;
        this.type = type;
        this.closure = closure;
    }

    @Override
    public Class<Object> getProducedType() {
        return Object.class;
    }

    @Override
    public Class<Object> getConsumedType() {
        return Object.class;
    }

    @Override
    public void provide(Object element) throws IOException {
        Object ret;
        if (this.type.isInstance(element) && (ret = this.closure.call(element)) != null) {
            this.consumer.provide(ret);
        }
    }

    @Override
    public void open(CommandContext<? super Object> consumer) {
        this.consumer = consumer;
        ClosureDelegate delegate = new ClosureDelegate(consumer, this.closure.getOwner());
        this.closure.setResolveStrategy(1);
        this.closure.setDelegate((Object)delegate);
    }

    @Override
    public void flush() throws IOException {
        this.consumer.flush();
    }

    @Override
    public void close() {
        this.consumer = null;
    }
}

