/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.net.URL;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PluginManager;
import org.crsh.ssh.term.CRaSHCommandFactory;
import org.crsh.ssh.term.CRaSHPEMGeneratorHostKeyProvider;
import org.crsh.ssh.term.scp.CommandPlugin;
import org.crsh.ssh.term.scp.SCPCommandFactory;
import org.crsh.term.CRaSHLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHLifeCycle
extends CRaSHLifeCycle {
    public static final Session.AttributeKey<String> USERNAME = new Session.AttributeKey();
    public static final Session.AttributeKey<String> PASSWORD = new Session.AttributeKey();
    private final Logger log = LoggerFactory.getLogger(SSHLifeCycle.class);
    private SshServer server;
    private int port;
    private String keyPath;
    private URL keyURL;

    public SSHLifeCycle(PluginContext context) {
        super(context);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    public URL getKeyURL() {
        return this.keyURL;
    }

    public void setKeyURL(URL keyURL) {
        this.keyURL = keyURL;
    }

    protected void doInit() {
        try {
            PluginManager commandPlugins = new PluginManager(this.getShellContext(), CommandPlugin.class);
            SshServer server = SshServer.setUpDefaultServer();
            server.setPort(this.port);
            server.setShellFactory(new CRaSHCommandFactory(this.getShellFactory(), this.getExecutor()));
            server.setCommandFactory(new SCPCommandFactory((PluginManager<CommandPlugin>)commandPlugins));
            server.setKeyPairProvider(new CRaSHPEMGeneratorHostKeyProvider(this.keyPath, this.keyURL));
            server.setPasswordAuthenticator(new PasswordAuthenticator(){

                public boolean authenticate(String _username, String _password, ServerSession session) {
                    session.setAttribute(USERNAME, _username);
                    session.setAttribute(PASSWORD, _password);
                    return true;
                }
            });
            this.log.info("About to start CRaSSHD");
            server.start();
            this.log.info("CRaSSHD started on port " + this.port);
            this.server = server;
        }
        catch (Throwable e) {
            this.log.error("Could not start CRaSSHD", e);
        }
    }

    protected void doDestroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                this.log.debug("Got an interruption when stopping server", (Throwable)e);
            }
        }
    }
}

