/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.sshd.common.util.SecurityUtils;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.vfs.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSHPlugin
extends CRaSHPlugin<SSHPlugin> {
    public static final PropertyDescriptor<Integer> SSH_PORT = PropertyDescriptor.create((String)"ssh.port", (Integer)2000, (String)"The SSH port");
    public static final PropertyDescriptor<String> SSH_KEYPATH = PropertyDescriptor.create((String)"ssh.keypath", (String)null, (String)"The path to the key file");
    public static final PropertyDescriptor<String> AUTH = PropertyDescriptor.create((String)"auth", (String)null, (String)"The authentication plugin");
    private SSHLifeCycle lifeCycle;

    public SSHPlugin getImplementation() {
        return this;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(SSH_PORT, SSH_KEYPATH, AUTH);
    }

    public void init() {
        String keyPath;
        SecurityUtils.setRegisterBouncyCastle((boolean)true);
        Integer port = (Integer)this.getContext().getProperty(SSH_PORT);
        if (port == null) {
            this.log.info("Could not boot SSHD due to missing due to missing port configuration");
            return;
        }
        Resource res = this.getContext().loadResource("hostkey.pem", ResourceKind.KEY);
        URL keyURL = null;
        if (res != null) {
            keyURL = res.getURL();
            this.log.debug("Found key url " + keyURL);
        }
        if ((keyPath = (String)this.getContext().getProperty(SSH_KEYPATH)) != null) {
            this.log.debug("Found key path " + keyPath);
            File f = new File(keyPath);
            if (f.exists() && f.isFile()) {
                try {
                    keyURL = f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    this.log.debug("Ignoring invalid key " + keyPath, (Throwable)e);
                }
            } else {
                this.log.debug("Ignoring invalid key path " + keyPath);
            }
        }
        if (keyURL == null) {
            this.log.info("Could not boot SSHD due to missing key");
            return;
        }
        String authentication = (String)this.getContext().getProperty(AUTH);
        this.log.info("Booting SSHD");
        SSHLifeCycle lifeCycle = new SSHLifeCycle(this.getContext());
        lifeCycle.setPort(port);
        lifeCycle.setKeyURL(keyURL);
        lifeCycle.setAuthentication(authentication);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.log.info("Shutting down SSHD");
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

