/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import org.apache.sshd.common.util.SecurityUtils;
import org.crsh.auth.AuthenticationPlugin;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.ssh.term.FilePublicKeyProvider;
import org.crsh.ssh.term.SSHLifeCycle;
import org.crsh.vfs.Resource;

public class SSHPlugin
extends CRaSHPlugin<SSHPlugin> {
    private static final String[] TYPES = new String[]{"ssh-dss", "ssh-rsa"};
    public static final PropertyDescriptor<Integer> SSH_PORT = PropertyDescriptor.create((String)"ssh.port", (Integer)2000, (String)"The SSH port");
    public static final PropertyDescriptor<String> SSH_SERVER_KEYPATH = PropertyDescriptor.create((String)"ssh.keypath", (String)null, (String)"The path to the key file");
    public static final PropertyDescriptor<String> SSH_AUTHORIZED_KEYPATH = PropertyDescriptor.create((String)"ssh.authorized.keypath", (String)null, (String)"The path to the authorized key file");
    private SSHLifeCycle lifeCycle;

    public SSHPlugin getImplementation() {
        return this;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Arrays.asList(SSH_PORT, SSH_SERVER_KEYPATH, SSH_AUTHORIZED_KEYPATH, AuthenticationPlugin.AUTH);
    }

    public void init() {
        String serverKeyPath;
        Resource serverKeyRes;
        SecurityUtils.setRegisterBouncyCastle(true);
        Integer port = (Integer)this.getContext().getProperty(SSH_PORT);
        if (port == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing due to missing port configuration");
            return;
        }
        Resource serverKey = null;
        URL serverKeyURL = SSHPlugin.class.getResource("/crash/hostkey.pem");
        if (serverKeyURL != null) {
            try {
                this.log.log(Level.FINE, "Found embedded key url " + serverKeyURL);
                serverKey = new Resource(serverKeyURL);
            }
            catch (IOException e) {
                this.log.log(Level.FINE, "Could not load ssh key from url " + serverKeyURL, e);
            }
        }
        if ((serverKeyRes = this.getContext().loadResource("hostkey.pem", ResourceKind.CONFIG)) != null) {
            serverKey = serverKeyRes;
            this.log.log(Level.FINE, "Found server ssh key url");
        }
        if ((serverKeyPath = (String)this.getContext().getProperty(SSH_SERVER_KEYPATH)) != null) {
            this.log.log(Level.FINE, "Found server key path " + serverKeyPath);
            File f = new File(serverKeyPath);
            if (f.exists() && f.isFile()) {
                try {
                    serverKeyURL = f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    this.log.log(Level.FINE, "Ignoring invalid server key " + serverKeyPath, e);
                }
            } else {
                this.log.log(Level.FINE, "Ignoring invalid server key path " + serverKeyPath);
            }
        }
        if (serverKeyURL == null) {
            this.log.log(Level.INFO, "Could not boot SSHD due to missing server key");
            return;
        }
        Set<PublicKey> authorizedKeys = Collections.emptySet();
        String authorizedKeyPath = (String)this.getContext().getProperty(SSH_AUTHORIZED_KEYPATH);
        if (authorizedKeyPath != null) {
            File f = new File(authorizedKeyPath);
            if (f.exists() && f.isFile()) {
                this.log.log(Level.FINE, "Found authorized key path " + authorizedKeyPath);
                authorizedKeys = new LinkedHashSet<PublicKey>();
                FilePublicKeyProvider provider = new FilePublicKeyProvider(new String[]{authorizedKeyPath});
                for (String type : TYPES) {
                    PublicKey key;
                    KeyPair pair = provider.loadKey(type);
                    if (pair == null || (key = pair.getPublic()) == null) continue;
                    authorizedKeys.add(key);
                }
            } else {
                this.log.log(Level.FINE, "Ignoring invalid authorized key path " + authorizedKeyPath);
            }
        }
        AuthenticationPlugin authPlugin = AuthenticationPlugin.NULL;
        String authentication = (String)this.getContext().getProperty(AuthenticationPlugin.AUTH);
        if (authentication != null) {
            for (AuthenticationPlugin authenticationPlugin : this.getContext().getPlugins(AuthenticationPlugin.class)) {
                if (!authentication.equals(authenticationPlugin.getName())) continue;
                authPlugin = authenticationPlugin;
                break;
            }
        }
        this.log.log(Level.INFO, "Booting SSHD");
        SSHLifeCycle lifeCycle = new SSHLifeCycle(this.getContext(), authPlugin, authorizedKeys);
        lifeCycle.setPort(port);
        lifeCycle.setKey(serverKey);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.log.log(Level.INFO, "Shutting down SSHD");
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

