/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.util.SttySupport;
import org.crsh.util.Safe;

public class SSHClient {
    static final String TTY = "speed 9600 baud; 36 rows; 180 columns;\nlflags: icanon isig iexten echo echoe -echok echoke -echonl echoctl\n\t-echoprt -altwerase -noflsh -tostop -flusho pendin -nokerninfo\n\t-extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel iutf8\n\t-ignbrk brkint -inpck -ignpar -parmrk\noflags: opost onlcr -oxtabs -onocr -onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -dsrflow\n\t-dtrflow -mdmbuf\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\n\teol2 = <undef>; erase = ^?; intr = ^C; kill = ^U; lnext = ^V;\n\tmin = 1; quit = ^\\; reprint = ^R; start = ^Q; status = ^T;\n\tstop = ^S; susp = ^Z; time = 0; werase = ^W;";
    private OutputStream out;
    private InputStream in;
    private SshClient client;
    private ClientSession session;
    private ChannelShell channel;
    private int port;

    public SSHClient() {
        this(2000);
    }

    public SSHClient(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public SSHClient connect() throws Exception {
        Map tty = SttySupport.parsePtyModes((String)TTY);
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        ClientSession session = ((ConnectFuture)client.connect("localhost", this.port).await()).getSession();
        session.authPassword("root", "");
        ChannelShell channel = session.createShellChannel();
        channel.setPtyModes(tty);
        PipedOutputStream out = new PipedOutputStream();
        PipedInputStream channelIn = new PipedInputStream(out);
        PipedOutputStream channelOut = new PipedOutputStream();
        PipedInputStream in = new PipedInputStream(channelOut);
        channel.setIn((InputStream)channelIn);
        channel.setOut((OutputStream)channelOut);
        channel.setErr((OutputStream)new ByteArrayOutputStream());
        channel.open();
        this.channel = channel;
        this.client = client;
        this.session = session;
        this.out = out;
        this.in = in;
        return this;
    }

    public SSHClient write(CharSequence s) throws IOException {
        return this.write(((Object)s).toString().getBytes("UTF-8"));
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public SSHClient write(byte ... bytes) throws IOException {
        this.out.write(bytes);
        return this;
    }

    public SSHClient flush() throws IOException {
        this.out.flush();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSHClient close() {
        try {
            Safe.close((Closeable)this.out);
            this.channel.close(false);
            this.session.close(false);
            this.client.stop();
            SSHClient sSHClient = this;
            return sSHClient;
        }
        finally {
            this.client = null;
            this.channel = null;
            this.session = null;
            this.out = null;
        }
    }
}

