/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet;

import java.net.URL;
import java.util.Collections;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.plugin.ResourceKind;
import org.crsh.telnet.term.TelnetLifeCycle;
import org.crsh.vfs.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelnetPlugin
extends CRaSHPlugin<TelnetPlugin> {
    public static final PropertyDescriptor<Integer> TELNET_PORT = PropertyDescriptor.create((String)"telnet.port", (Integer)5000, (String)"The telnet port");
    private TelnetLifeCycle lifeCycle;

    public TelnetPlugin getImplementation() {
        return this;
    }

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Collections.singletonList(TELNET_PORT);
    }

    public void init() {
        Resource res;
        PluginContext context = this.getContext();
        URL configURL = TelnetPlugin.class.getResource("telnet.properties");
        if (configURL != null) {
            this.log.debug("Found embedded telnet config url " + configURL);
        }
        if ((res = this.getContext().loadResource("telnet.properties", ResourceKind.CONFIG)) != null) {
            configURL = res.getURL();
            this.log.debug("Found telnet config url " + configURL);
        }
        if (configURL == null) {
            this.log.info("Could not boot Telnet due to missing config");
            return;
        }
        TelnetLifeCycle lifeCycle = new TelnetLifeCycle(context);
        lifeCycle.setConfigURL(configURL);
        Integer port = (Integer)context.getProperty(TELNET_PORT);
        if (port != null) {
            lifeCycle.setPort(port);
        }
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void destroy() {
        if (this.lifeCycle != null) {
            this.lifeCycle.destroy();
        }
    }
}

