/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.web.client;

import com.google.gwt.dom.client.Document;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.user.client.ui.FocusWidget;
import org.crsh.web.client.TermText;

final class TermText
extends FocusWidget {
    private final StringBuilder buffer;
    private final StringBuilder state;
    private boolean on;
    private int height;

    TermText(int height) {
        super(Document.get().createElement("pre"));
        if (height <= 0) {
            throw new IllegalArgumentException("Cannot give a non positive height");
        }
        this.addMouseDownHandler((MouseDownHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.setStyleName("crash-term");
        this.state = new StringBuilder();
        this.on = false;
        this.buffer = new StringBuilder();
        this.height = height;
    }

    protected void onAttach() {
        super.onAttach();
        2 t = new /* Unavailable Anonymous Inner Class!! */;
        t.scheduleRepeating(500);
    }

    void clear() {
        int index = this.state.lastIndexOf("\n");
        if (index == -1) {
            this.state.setLength(0);
        } else {
            this.state.delete(0, index + 1);
        }
    }

    String getBuffer() {
        return this.buffer.length() > 0 ? this.buffer.toString() : "";
    }

    void bufferAppend(CharSequence s) {
        this.buffer.append(s);
        this.state.append(s);
    }

    void bufferAppend(char c) {
        this.buffer.append(c);
        this.state.append(c);
    }

    void bufferDrop() {
        if (this.buffer.length() > 0) {
            this.buffer.setLength(this.buffer.length() - 1);
            if (this.state.length() > 0) {
                this.state.setLength(this.state.length() - 1);
            }
        }
    }

    String bufferSubmit() {
        String s = this.buffer.toString();
        this.buffer.setLength(0);
        this.state.append('\n');
        return s;
    }

    void print(char c) {
        this.state.append(c);
    }

    void print(CharSequence text) {
        this.state.append(text);
    }

    void repaint() {
        StringBuilder markup = new StringBuilder();
        int lines = 0;
        int from = 0;
        while (true) {
            ++lines;
            int to = this.state.indexOf("\n", from);
            markup.append(this.state, from, to == -1 ? this.state.length() : to);
            if (to == -1) break;
            markup.append("\n");
            from = to + 1;
        }
        markup.append("<span id=\"crash-cursor\" class=\"crash-cursor\">&nbsp;</span>");
        while (lines++ < this.height) {
            markup.append("&nbsp;\n");
        }
        this.getElement().setInnerHTML(markup.toString());
    }

    static /* synthetic */ boolean access$002(TermText x0, boolean x1) {
        x0.on = x1;
        return x0.on;
    }

    static /* synthetic */ boolean access$000(TermText x0) {
        return x0.on;
    }
}

