/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.web.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.crsh.plugin.PluginContext;
import org.crsh.plugin.WebPluginLifeCycle;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.concurrent.SyncShellResponseContext;
import org.crsh.shell.impl.CRaSH;
import org.crsh.standalone.Bootstrap;
import org.crsh.util.Strings;
import org.crsh.web.client.ShellService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShellServiceImpl
extends RemoteServiceServlet
implements ShellService {
    private static final Logger log = LoggerFactory.getLogger(ShellServiceImpl.class);
    private PluginContext pluginContext;

    public ShellServiceImpl() {
    }

    public ShellServiceImpl(Object delegate) {
        super(delegate);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.pluginContext = WebPluginLifeCycle.getPluginContext((ServletContext)config.getServletContext());
        if (this.pluginContext == null) {
            try {
                Bootstrap bootstrap = new Bootstrap();
                bootstrap.bootstrap();
                this.pluginContext = bootstrap.getContext();
            }
            catch (Exception e) {
                log.error("Bootstrap failed", (Throwable)e);
            }
        } else {
            log.info("Obtained plugin context " + this.pluginContext);
        }
    }

    private Shell getShell() {
        HttpServletRequest req = this.getThreadLocalRequest();
        HttpSession session = req.getSession();
        CRaSH shell = (CRaSH)session.getAttribute(ShellServiceImpl.class.getName());
        if (shell == null) {
            log.debug("Created shell");
            shell = new CRaSH(this.pluginContext);
            session.setAttribute(ShellServiceImpl.class.getName(), (Object)shell);
        }
        return shell;
    }

    public String getWelcome() {
        Shell shell = this.getShell();
        return shell.getWelcome() + "\n" + shell.getPrompt();
    }

    public String process(String s) {
        Shell shell = this.getShell();
        StringBuilder sb = new StringBuilder();
        try {
            SyncShellResponseContext resp = new SyncShellResponseContext();
            shell.process(s, (ShellProcessContext)resp);
            String text = resp.getResponse().getText();
            sb.append(text);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            sb.append("failure ").append(e.getMessage());
        }
        sb.append('\n').append(shell.getPrompt());
        return sb.toString();
    }

    public Map<String, String> complete(String s) {
        String commonCompletion;
        Shell shell = this.getShell();
        Map completions = shell.complete(s);
        if (completions.size() == 0) {
            commonCompletion = "";
        } else if (completions.size() == 1) {
            Map.Entry entry = completions.entrySet().iterator().next();
            commonCompletion = (String)entry.getKey() + (String)entry.getValue();
        } else {
            commonCompletion = Strings.findLongestCommonPrefix(completions.keySet());
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        if (commonCompletion.length() > 0) {
            ret.put(commonCompletion, "");
        } else if (completions.size() > 1) {
            ret.putAll(completions);
        }
        return ret;
    }
}

