/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.web.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.user.cellview.client.CellList;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DecoratedPopupPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Map;
import org.crsh.web.client.ShellServiceAsync;
import org.crsh.web.client.Term;
import org.crsh.web.client.TermText;

public final class Term
extends Composite {
    private final TermText text;
    private final ScrollPanel scroll;
    private final ShellServiceAsync remote;
    private final DecoratedPopupPanel popup;
    private final KeyPressHandler pressHandler = new KeyPressHandler(){

        public void onKeyPress(KeyPressEvent event) {
            int code = event.getNativeEvent().getKeyCode();
            boolean handled = false;
            if (code == 8) {
                Term.this.text.bufferDrop();
                handled = true;
            } else if (code == 13) {
                String s = Term.this.text.bufferSubmit();
                Term.this.remote.process(s, new AsyncCallback<String>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(String result) {
                        Term.this.print(result);
                    }
                });
                handled = true;
            } else {
                char c = event.getCharCode();
                if (Character.isLetterOrDigit(c) || c == ' ' || c == '-') {
                    Term.this.text.bufferAppend(c);
                    handled = true;
                }
            }
            if (handled) {
                Term.this.repaint();
                event.preventDefault();
                event.stopPropagation();
            }
        }
    };
    private final CloseHandler<PopupPanel> closePopup = new CloseHandler<PopupPanel>(){

        public void onClose(CloseEvent<PopupPanel> event) {
            ((PopupPanel)event.getTarget()).setWidget(null);
            Term.this.text.setFocus(true);
            Term.this.repaint();
        }
    };
    private final KeyDownHandler downHandler = new KeyDownHandler(){

        public void onKeyDown(KeyDownEvent event) {
            int code = event.getNativeKeyCode();
            if (code == 9) {
                Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Completer());
                event.preventDefault();
                event.stopPropagation();
            } else if (code == 38) {
                event.preventDefault();
                event.stopPropagation();
            } else if (code == 40) {
                event.preventDefault();
                event.stopPropagation();
            } else if (code == 37) {
                event.preventDefault();
                event.stopPropagation();
            } else if (code == 39) {
                event.preventDefault();
                event.stopPropagation();
            }
        }
    };

    public Term(ShellServiceAsync remote, int height) {
        TermText text = new TermText(height);
        text.addKeyPressHandler(this.pressHandler);
        text.addKeyDownHandler(this.downHandler);
        ScrollPanel scroll = new ScrollPanel((Widget)text);
        scroll.setSize("800px", "600px");
        DecoratedPopupPanel popup = new DecoratedPopupPanel(true, false);
        popup.addCloseHandler(this.closePopup);
        this.initWidget((Widget)scroll);
        this.text = text;
        this.scroll = scroll;
        this.remote = remote;
        this.popup = popup;
    }

    protected void onAttach() {
        super.onAttach();
        this.remote.getWelcome(new AsyncCallback<String>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(String result) {
                Term.this.print(result);
            }
        });
    }

    private void repaint() {
        this.text.repaint();
        this.scroll.scrollToBottom();
    }

    public void clear() {
        this.text.clear();
        this.repaint();
    }

    public void print(char c) {
        this.text.print(c);
        this.repaint();
    }

    public void print(CharSequence s) {
        this.text.print(s);
        this.repaint();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Completer
    implements Scheduler.ScheduledCommand,
    AsyncCallback<Map<String, String>> {
        private Completer() {
        }

        public void execute() {
            String prefix = Term.this.text.getBuffer();
            Term.this.remote.complete(prefix, this);
        }

        public void onFailure(Throwable caught) {
        }

        public void onSuccess(final Map<String, String> result) {
            if (result.size() == 1) {
                Term.this.text.bufferAppend(result.keySet().iterator().next());
                Term.this.repaint();
            } else if (result.size() > 1) {
                Element elt = DOM.getElementById((String)"crash-cursor");
                final ArrayList<String> strings = new ArrayList<String>(result.keySet());
                ListDataProvider a = new ListDataProvider(strings);
                AbstractCell<String> cell = new AbstractCell<String>(new String[0]){

                    public void render(String value, Object key, SafeHtmlBuilder sb) {
                        if (value != null) {
                            sb.appendHtmlConstant("<span class=\"crash-autocomplete\">");
                            sb.appendEscaped(value);
                            sb.appendHtmlConstant("</span>");
                        }
                    }
                };
                final SingleSelectionModel model = new SingleSelectionModel();
                model.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

                    public void onSelectionChange(SelectionChangeEvent event) {
                        String selected = (String)model.getSelectedObject();
                        String value = (String)result.get(selected);
                        class SelectCommand
                        implements Scheduler.ScheduledCommand {
                            private final String value;
                            final /* synthetic */ Completer this$1;

                            SelectCommand(Completer completer, String value) {
                                this.this$1 = completer;
                                this.value = value;
                            }

                            public void execute() {
                                Term.access$000(this.this$1.Term.this).bufferAppend(this.value);
                                Term.access$400(this.this$1.Term.this).hide();
                            }
                        }
                        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new SelectCommand(Completer.this, selected + value));
                    }
                });
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class CompleteList
                extends CellList<String> {
                    CompleteList(Cell<String> stringCell) {
                        super(stringCell);
                    }

                    protected void onBrowserEvent2(Event event) {
                        if ("keydown".equals(event.getType())) {
                            int code = event.getKeyCode();
                            if (code == 13) {
                                int index = this.getKeyboardSelectedRow();
                                String selected = (String)strings.get(index);
                                String rest = (String)result.get(selected);
                                String value = selected + rest;
                                Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new SelectCommand(this, value));
                                return;
                            }
                            if (code == 27) {
                                Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                                    public void execute() {
                                        Term.this.popup.hide();
                                        Term.this.repaint();
                                    }
                                });
                            }
                        }
                        super.onBrowserEvent2(event);
                    }

                    protected void setKeyboardSelected(int index, boolean selected, boolean stealFocus) {
                        super.setKeyboardSelected(index, selected, stealFocus);
                    }
                }
                CompleteList list = new CompleteList((Cell)cell);
                a.addDataDisplay((HasData)list);
                list.setSelectionModel((SelectionModel)model);
                list.setKeyboardSelected(0, true, true);
                Term.this.popup.setWidget((Widget)list);
                Term.this.popup.setPopupPosition(elt.getAbsoluteLeft(), elt.getAbsoluteTop());
                Term.this.popup.show();
                list.setFocus(true);
            }
        }
    }
}

