/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import com.google.common.io.BaseEncoding;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.cryptomator.cryptofs.LongFileNameProvider;
import org.cryptomator.cryptofs.common.StringUtils;
import org.cryptomator.cryptofs.dir.DirectoryStreamScoped;
import org.cryptomator.cryptofs.dir.Node;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DirectoryStreamScoped
class C9sInflator {
    private static final Logger LOG = LoggerFactory.getLogger(C9sInflator.class);
    private final LongFileNameProvider longFileNameProvider;
    private final Cryptor cryptor;
    private final byte[] dirId;

    @Inject
    public C9sInflator(LongFileNameProvider longFileNameProvider, Cryptor cryptor, @Named(value="dirId") String dirId) {
        this.longFileNameProvider = longFileNameProvider;
        this.cryptor = cryptor;
        this.dirId = dirId.getBytes(StandardCharsets.US_ASCII);
    }

    public Stream<Node> process(Node node) {
        try {
            String c9rName = this.longFileNameProvider.inflate(node.ciphertextPath);
            node.extractedCiphertext = StringUtils.removeEnd(c9rName, ".c9r");
            node.cleartextName = this.cryptor.fileNameCryptor().decryptFilename(BaseEncoding.base64Url(), node.extractedCiphertext, (byte[][])new byte[][]{this.dirId});
            return Stream.of(node);
        }
        catch (AuthenticationFailedException e) {
            LOG.warn("{}'s inflated filename could not be decrypted.", (Object)node.ciphertextPath);
            return Stream.empty();
        }
        catch (IOException e) {
            LOG.warn("{} could not be inflated.", (Object)node.ciphertextPath);
            return Stream.empty();
        }
    }
}

