/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.cryptomator.cryptofs.dir.DirectoryStreamScoped;
import org.cryptomator.cryptofs.dir.Node;
import org.cryptomator.cryptofs.dir.NodeProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DirectoryStreamScoped
public class CryptoDirectoryStream
implements DirectoryStream<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoDirectoryStream.class);
    private final String directoryId;
    private final DirectoryStream<Path> ciphertextDirStream;
    private final Path cleartextDir;
    private final DirectoryStream.Filter<? super Path> filter;
    private final Consumer<CryptoDirectoryStream> onClose;
    private final NodeProcessor nodeProcessor;

    @Inject
    public CryptoDirectoryStream(@Named(value="dirId") String dirId, DirectoryStream<Path> ciphertextDirStream, @Named(value="cleartextPath") Path cleartextDir, DirectoryStream.Filter<? super Path> filter, Consumer<CryptoDirectoryStream> onClose, NodeProcessor nodeProcessor) {
        LOG.trace("OPEN {}", (Object)dirId);
        this.directoryId = dirId;
        this.ciphertextDirStream = ciphertextDirStream;
        this.cleartextDir = cleartextDir;
        this.filter = filter;
        this.onClose = onClose;
        this.nodeProcessor = nodeProcessor;
    }

    @Override
    public Iterator<Path> iterator() {
        return this.cleartextDirectoryListing().iterator();
    }

    private Stream<Path> cleartextDirectoryListing() {
        return this.directoryListing().map(node -> this.cleartextDir.resolve(node.cleartextName)).filter(this::isAcceptableByFilter);
    }

    Stream<Path> ciphertextDirectoryListing() {
        return this.directoryListing().map(node -> node.ciphertextPath);
    }

    private Stream<Node> directoryListing() {
        return StreamSupport.stream(this.ciphertextDirStream.spliterator(), false).map(Node::new).flatMap(this.nodeProcessor::process);
    }

    private boolean isAcceptableByFilter(Path path) {
        try {
            return this.filter.accept(path);
        }
        catch (IOException e) {
            throw new DirectoryIteratorException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.ciphertextDirStream.close();
            LOG.trace("CLOSE {}", (Object)this.directoryId);
        }
        finally {
            this.onClose.accept(this);
        }
    }
}

