/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.fh;

import jakarta.inject.Inject;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptolib.api.Cryptor;

@CryptoFileSystemScoped
public class BufferPool {
    private final int ciphertextChunkSize;
    private final int cleartextChunkSize;
    private final Queue<WeakReference<ByteBuffer>> ciphertextBuffers = new ConcurrentLinkedQueue<WeakReference<ByteBuffer>>();
    private final Queue<WeakReference<ByteBuffer>> cleartextBuffers = new ConcurrentLinkedQueue<WeakReference<ByteBuffer>>();

    @Inject
    public BufferPool(Cryptor cryptor) {
        this.ciphertextChunkSize = cryptor.fileContentCryptor().ciphertextChunkSize();
        this.cleartextChunkSize = cryptor.fileContentCryptor().cleartextChunkSize();
    }

    private Optional<ByteBuffer> dequeueFrom(Queue<WeakReference<ByteBuffer>> queue) {
        WeakReference<ByteBuffer> ref;
        while ((ref = queue.poll()) != null) {
            ByteBuffer cached = (ByteBuffer)ref.get();
            if (cached == null) continue;
            cached.clear();
            return Optional.of(cached);
        }
        return Optional.empty();
    }

    public ByteBuffer getCiphertextBuffer() {
        return this.dequeueFrom(this.ciphertextBuffers).orElseGet(() -> ByteBuffer.allocate(this.ciphertextChunkSize));
    }

    public ByteBuffer getCleartextBuffer() {
        return this.dequeueFrom(this.cleartextBuffers).orElseGet(() -> ByteBuffer.allocate(this.cleartextChunkSize));
    }

    public void recycle(ByteBuffer buffer) {
        if (buffer.capacity() == this.ciphertextChunkSize) {
            this.ciphertextBuffers.add(new WeakReference<ByteBuffer>(buffer));
        } else if (buffer.capacity() == this.cleartextChunkSize) {
            this.cleartextBuffers.add(new WeakReference<ByteBuffer>(buffer));
        }
    }
}

