/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.shaded.bouncycastle.pqc.jcajce.provider.bike;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PublicKey;
import org.cryptomator.cryptolib.shaded.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.crypto.util.SubjectPublicKeyInfoFactory;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.jcajce.interfaces.BIKEKey;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.jcajce.spec.BIKEParameterSpec;
import org.cryptomator.cryptolib.shaded.bouncycastle.util.Arrays;
import org.cryptomator.cryptolib.shaded.bouncycastle.util.Strings;

public class BCBIKEPublicKey
implements PublicKey,
BIKEKey {
    private static final long serialVersionUID = 1L;
    private transient BIKEPublicKeyParameters params;

    public BCBIKEPublicKey(BIKEPublicKeyParameters bIKEPublicKeyParameters) {
        this.params = bIKEPublicKeyParameters;
    }

    public BCBIKEPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.init(subjectPublicKeyInfo);
    }

    private void init(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
        this.params = (BIKEPublicKeyParameters)PublicKeyFactory.createKey(subjectPublicKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCBIKEPublicKey) {
            BCBIKEPublicKey bCBIKEPublicKey = (BCBIKEPublicKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCBIKEPublicKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return Strings.toUpperCase(this.params.getParameters().getName());
    }

    @Override
    public byte[] getEncoded() {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(this.params);
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public BIKEParameterSpec getParameterSpec() {
        return BIKEParameterSpec.fromName(this.params.getParameters().getName());
    }

    BIKEPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

