/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.nio.file.AccessMode;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;
import org.cryptomator.jfuse.api.Stat;

public class FileAttributesUtil {
    private static final int DUMMY_UID = 65534;
    private static final int DUMMY_GID = 65534;

    private FileAttributesUtil() {
    }

    public static Set<AccessMode> accessModeMaskToSet(int mask) {
        EnumSet<AccessMode> accessModes = EnumSet.noneOf(AccessMode.class);
        if ((mask & 4) == 4) {
            accessModes.add(AccessMode.READ);
        }
        if ((mask & 2) == 2) {
            accessModes.add(AccessMode.WRITE);
        }
        if ((mask & 1) == 1) {
            accessModes.add(AccessMode.EXECUTE);
        }
        return accessModes;
    }

    public static Set<PosixFilePermission> octalModeToPosixPermissions(long mode) {
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100L) == 256L) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80L) == 128L) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40L) == 64L) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20L) == 32L) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10L) == 16L) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8L) == 8L) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4L) == 4L) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2L) == 2L) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1L) == 1L) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public static void copyBasicFileAttributesFromNioToFuse(BasicFileAttributes attrs, Stat stat) {
        stat.unsetModeBits(61440);
        if (attrs.isDirectory()) {
            stat.setModeBits(16384);
        } else if (attrs.isRegularFile()) {
            stat.setModeBits(32768);
        } else if (attrs.isSymbolicLink()) {
            stat.setModeBits(40960);
        }
        stat.setUid(65534);
        stat.setGid(65534);
        stat.mTime().set(attrs.lastModifiedTime().toInstant());
        stat.birthTime().set(attrs.creationTime().toInstant());
        stat.aTime().set(attrs.lastAccessTime().toInstant());
        stat.setSize(attrs.size());
        stat.setNLink((short)1);
    }

    public static long posixPermissionsToOctalMode(Set<PosixFilePermission> permissions) {
        long mode = 0L;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100L;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20L;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4L;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80L;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10L;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2L;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40L;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8L;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1L;
        }
        return mode;
    }
}

