/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import org.cryptomator.frontend.fuse.FileAttributesUtil;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.jfuse.api.Stat;

class ReadOnlyLinkHandler {
    private final FileNameTranscoder fileNameTranscoder;

    public ReadOnlyLinkHandler(FileNameTranscoder fileNameTranscoder) {
        this.fileNameTranscoder = fileNameTranscoder;
    }

    public int getattr(Path path, BasicFileAttributes attrs, Stat stat) {
        if (attrs instanceof PosixFileAttributes) {
            PosixFileAttributes posixAttrs = (PosixFileAttributes)attrs;
            stat.setPermissions(posixAttrs.permissions());
        } else {
            stat.setMode(365);
        }
        stat.setModeBits(40960);
        FileAttributesUtil.copyBasicFileAttributesFromNioToFuse(attrs, stat);
        return 0;
    }

    public int readlink(Path path, ByteBuffer buf, long size) throws IOException {
        if (path.getParent() == null) {
            throw new NotLinkException("Root cannot be a link");
        }
        Path target = Files.readSymbolicLink(path);
        ByteBuffer fuseEncodedTarget = this.fileNameTranscoder.interpretAsFuseString(this.fileNameTranscoder.nioToFuse(target.toString()));
        int len = (int)Math.min((long)fuseEncodedTarget.remaining(), size - 1L);
        assert ((long)len < size);
        buf.put(0, fuseEncodedTarget.array(), 0, len);
        buf.put(len, (byte)0);
        return 0;
    }
}

