/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeoutException;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.Mountpoint;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.cryptomator.jfuse.api.Fuse;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

abstract class AbstractMount
implements Mount {
    protected final Fuse fuse;
    protected final FuseNioAdapter fuseNioAdapter;
    protected final Path mountpoint;

    public AbstractMount(Fuse fuse, FuseNioAdapter fuseNioAdapter, Path mountpoint) {
        this.fuse = fuse;
        this.fuseNioAdapter = fuseNioAdapter;
        this.mountpoint = mountpoint;
    }

    public Mountpoint getMountpoint() {
        return Mountpoint.forPath((Path)this.mountpoint);
    }

    @MustBeInvokedByOverriders
    public void close() throws UnmountFailedException, IOException {
        try {
            this.fuse.close();
            this.fuseNioAdapter.close();
        }
        catch (TimeoutException e) {
            throw new UnmountFailedException("Fuse loop shutdown timed out.", (Exception)e);
        }
    }
}

