/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.ReadWriteAdapter;
import org.cryptomator.frontend.fuse.mount.AbstractMacMountBuilder;
import org.cryptomator.frontend.fuse.mount.MacMountedVolume;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseBuilder;
import org.cryptomator.jfuse.api.FuseMountFailedException;
import org.cryptomator.jfuse.api.FuseOperations;

@Priority(value=100)
@OperatingSystem(value=OperatingSystem.Value.MAC)
public class MacFuseMountProvider
implements MountService {
    private static final String[] DYLIB_PATHS = new String[]{"/usr/local/lib/libosxfuse.2.dylib", "/usr/local/lib/libfuse.2.dylib"};
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);

    public String displayName() {
        return "macFUSE";
    }

    public boolean isSupported() {
        return Arrays.stream(DYLIB_PATHS).map(x$0 -> Path.of(x$0, new String[0])).anyMatch(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    public MountBuilder forFileSystem(Path fileSystemRoot) {
        return new MacFuseMountBuilder(fileSystemRoot);
    }

    public Set<MountCapability> capabilities() {
        return EnumSet.of(MountCapability.MOUNT_FLAGS, new MountCapability[]{MountCapability.UNMOUNT_FORCED, MountCapability.READ_ONLY, MountCapability.MOUNT_TO_EXISTING_DIR, MountCapability.MOUNT_TO_SYSTEM_CHOSEN_PATH, MountCapability.VOLUME_ID, MountCapability.VOLUME_NAME});
    }

    public String getDefaultMountFlags() {
        try {
            return " -ouid=" + String.valueOf(Files.getAttribute(USER_HOME, "unix:uid", new LinkOption[0])) + " -ogid=" + String.valueOf(Files.getAttribute(USER_HOME, "unix:gid", new LinkOption[0])) + " -oatomic_o_trunc -oauto_xattr -oauto_cache -onoappledouble -odefault_permissions";
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class MacFuseMountBuilder
    extends AbstractMacMountBuilder {
        private String volumeId;

        public MacFuseMountBuilder(Path vfsRoot) {
            super(vfsRoot);
        }

        @Override
        public MountBuilder setMountpoint(Path mountPoint) {
            if (!(mountPoint.startsWith("/Volumes/") && Files.notExists(mountPoint, new LinkOption[0]) || Files.isDirectory(mountPoint, new LinkOption[0]))) {
                throw new IllegalArgumentException("mount point must be an existing directory");
            }
            this.mountPoint = mountPoint;
            return this;
        }

        public MountBuilder setVolumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public Mount mount() throws MountFailedException {
            Objects.requireNonNull(this.mountFlags);
            if (this.mountPoint == null) {
                Objects.requireNonNull(this.volumeId);
                this.mountPoint = Path.of("/Volumes/", this.volumeId);
            }
            FuseBuilder builder = Fuse.builder();
            String libPath = Arrays.stream(DYLIB_PATHS).filter(s -> Files.exists(Path.of(s, new String[0]), new LinkOption[0])).findFirst().orElseThrow(() -> new IllegalStateException("Unable to find fuse library during mount. Searched locations: %s".formatted(Arrays.toString(DYLIB_PATHS))));
            builder.setLibraryPath(libPath);
            FileNameTranscoder filenameTranscoder = FileNameTranscoder.transcoder().withFuseNormalization(Normalizer.Form.NFD);
            ReadWriteAdapter fuseAdapter = ReadWriteAdapter.create(builder.errno(), this.vfsRoot, 254, filenameTranscoder, true);
            Fuse fuse = builder.build((FuseOperations)fuseAdapter);
            try {
                fuse.mount("fuse-nio-adapter", this.mountPoint, (String[])this.combinedMountFlags().toArray(String[]::new));
                return new MacMountedVolume(fuse, fuseAdapter, this.mountPoint);
            }
            catch (FuseMountFailedException e) {
                throw new MountFailedException((Exception)((Object)e));
            }
        }
    }
}

