/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Blocking;

class ProcessHelper {
    private ProcessHelper() {
    }

    @Blocking
    static void waitForSuccess(Process process, int timeoutSeconds, String cmdDescription) throws TimeoutException, InterruptedException, CommandFailedException {
        boolean exited = process.waitFor(timeoutSeconds, TimeUnit.SECONDS);
        if (!exited) {
            throw new TimeoutException(cmdDescription + " timed out after " + timeoutSeconds + "s");
        }
        if (process.exitValue() != 0) {
            String stdout = process.inputReader(StandardCharsets.UTF_8).lines().collect(Collectors.joining("\n"));
            String stderr = process.errorReader(StandardCharsets.UTF_8).lines().collect(Collectors.joining("\n"));
            throw new CommandFailedException(cmdDescription, process.exitValue(), stdout, stderr);
        }
    }

    static class CommandFailedException
    extends Exception {
        int exitCode;
        String stdout;
        String stderr;

        private CommandFailedException(String cmdDescription, int exitCode, String stdout, String stderr) {
            super(cmdDescription + " returned with non-zero exit code " + exitCode);
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
        }
    }
}

