/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.fuse.mount;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.cryptomator.frontend.fuse.FileNameTranscoder;
import org.cryptomator.frontend.fuse.FuseNioAdapter;
import org.cryptomator.frontend.fuse.ReadWriteAdapter;
import org.cryptomator.frontend.fuse.mount.AbstractMount;
import org.cryptomator.frontend.fuse.mount.AbstractMountBuilder;
import org.cryptomator.frontend.fuse.mount.WinfspUtil;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseBuilder;
import org.cryptomator.jfuse.api.FuseMountFailedException;
import org.cryptomator.jfuse.api.FuseOperations;

@Priority(value=90)
@OperatingSystem(value=OperatingSystem.Value.WINDOWS)
public class WinFspMountProvider
implements MountService {
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase();

    public String displayName() {
        return "WinFsp (Local Drive)";
    }

    public boolean isSupported() {
        return WinfspUtil.isWinFspInstalled();
    }

    public Set<MountCapability> capabilities() {
        return EnumSet.of(MountCapability.MOUNT_FLAGS, new MountCapability[]{MountCapability.MOUNT_AS_DRIVE_LETTER, MountCapability.MOUNT_WITHIN_EXISTING_PARENT, MountCapability.UNMOUNT_FORCED, MountCapability.READ_ONLY, MountCapability.VOLUME_NAME, MountCapability.FILE_SYSTEM_NAME});
    }

    public String getDefaultMountFlags() {
        return "-ouid=-1 -ogid=-1";
    }

    public MountBuilder forFileSystem(Path vfsRoot) {
        return new WinFspMountBuilder(vfsRoot);
    }

    protected static class WinFspMountBuilder
    extends AbstractMountBuilder {
        private static String DEFAULT_FS_NAME = "FUSE-NIO-FS";
        String fsName = DEFAULT_FS_NAME;
        boolean isReadOnly = false;

        WinFspMountBuilder(Path vfsRoot) {
            super(vfsRoot);
        }

        @Override
        public MountBuilder setMountpoint(Path mountPoint) {
            if (mountPoint.getRoot().equals(mountPoint) || Files.isDirectory(mountPoint.getParent(), new LinkOption[0]) && Files.notExists(mountPoint, new LinkOption[0])) {
                this.mountPoint = mountPoint;
                return this;
            }
            throw new IllegalArgumentException("mount point must either be a drive letter or a non-existing node within an existing parent");
        }

        public MountBuilder setFileSystemName(String fsName) {
            this.fsName = fsName;
            return this;
        }

        public MountBuilder setReadOnly(boolean mountReadOnly) {
            this.isReadOnly = mountReadOnly;
            return this;
        }

        @Override
        protected Set<String> combinedMountFlags() {
            Set<String> combined = super.combinedMountFlags();
            if (this.isReadOnly) {
                combined.removeIf(flag -> flag.startsWith("-oumask="));
                combined.add("-oumask=0333");
            }
            combined.removeIf(flag -> flag.startsWith("-oExactFileSystemName="));
            combined.add("-oExactFileSystemName=" + this.fsName);
            if (this.volumeName != null && !this.volumeName.isBlank()) {
                combined.removeIf(flag -> flag.startsWith("-ovolname="));
                combined.add("-ovolname=" + this.volumeName);
            }
            return combined;
        }

        public Mount mount() throws MountFailedException {
            FuseBuilder builder = Fuse.builder();
            String libPath = WinfspUtil.getWinFspInstallDir() + "bin\\" + (OS_ARCH.contains("aarch64") ? "winfsp-a64.dll" : "winfsp-x64.dll");
            builder.setLibraryPath(libPath);
            ReadWriteAdapter fuseAdapter = ReadWriteAdapter.create(builder.errno(), this.vfsRoot, 254, FileNameTranscoder.transcoder(), false);
            try {
                Fuse fuse = builder.build((FuseOperations)fuseAdapter);
                fuse.mount("fuse-nio-adapter", this.mountPoint, (String[])this.combinedMountFlags().toArray(String[]::new));
                return new WinfspMount(fuse, fuseAdapter, this.mountPoint);
            }
            catch (FuseMountFailedException e) {
                throw new MountFailedException((Exception)((Object)e));
            }
        }
    }

    private static class WinfspMount
    extends AbstractMount {
        public WinfspMount(Fuse fuseBinding, FuseNioAdapter fuseNioAdapter, Path mountpoint) {
            super(fuseBinding, fuseNioAdapter, mountpoint);
        }

        public void unmount() throws UnmountFailedException {
            if (this.fuseNioAdapter.isInUse()) {
                throw new UnmountFailedException("Filesystem in use");
            }
            this.unmountForced();
        }

        public void unmountForced() throws UnmountFailedException {
            try {
                this.fuse.close();
            }
            catch (TimeoutException e) {
                throw new UnmountFailedException((Exception)e);
            }
        }
    }
}

