/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.linux.amd64;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import org.cryptomator.jfuse.api.FuseMount;
import org.cryptomator.jfuse.linux.amd64.FuseArgs;
import org.cryptomator.jfuse.linux.amd64.extr.fuse3.fuse_h;
import org.cryptomator.jfuse.linux.amd64.extr.fuse3.fuse_loop_config_v1;

record FuseMountImpl(MemorySegment fuse, FuseArgs fuseArgs) implements FuseMount
{
    private static final int FUSE_3_2 = 32;
    private static final int FUSE_3_12 = 312;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loop() {
        if (!this.fuseArgs.multithreaded() || fuse_h.fuse_version() < 32) {
            return fuse_h.fuse_loop(this.fuse);
        }
        if (fuse_h.fuse_version() < 312) {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment loopCfg = fuse_loop_config_v1.allocate(arena);
                fuse_loop_config_v1.clone_fd(loopCfg, this.fuseArgs.cloneFd());
                fuse_loop_config_v1.max_idle_threads(loopCfg, this.fuseArgs.maxIdleThreads());
                int n = fuse_h.fuse_loop_mt(this.fuse, loopCfg);
                return n;
            }
        }
        MemorySegment loopCfg = fuse_h.fuse_loop_cfg_create();
        try {
            fuse_h.fuse_loop_cfg_set_clone_fd(loopCfg, this.fuseArgs.cloneFd());
            fuse_h.fuse_loop_cfg_set_max_threads(loopCfg, this.fuseArgs.maxThreads());
            int n = fuse_h.fuse_loop_mt(this.fuse, loopCfg);
            return n;
        }
        finally {
            fuse_h.fuse_loop_cfg_destroy(loopCfg);
        }
    }

    public void unmount() {
        fuse_h.fuse_exit(this.fuse);
        fuse_h.fuse_unmount(this.fuse);
    }

    public void destroy() {
        fuse_h.fuse_destroy(this.fuse);
    }
}

