/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.win;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import org.cryptomator.jfuse.api.DirFiller;
import org.cryptomator.jfuse.api.FileInfo;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseConfig;
import org.cryptomator.jfuse.api.FuseConnInfo;
import org.cryptomator.jfuse.api.FuseMount;
import org.cryptomator.jfuse.api.FuseMountFailedException;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.Stat;
import org.cryptomator.jfuse.api.Statvfs;
import org.cryptomator.jfuse.api.TimeSpec;
import org.cryptomator.jfuse.api.util.MemoryUtils;
import org.cryptomator.jfuse.win.DirFillerImpl;
import org.cryptomator.jfuse.win.FileInfoImpl;
import org.cryptomator.jfuse.win.FuseArgs;
import org.cryptomator.jfuse.win.FuseConfigImpl;
import org.cryptomator.jfuse.win.FuseConnInfoImpl;
import org.cryptomator.jfuse.win.FuseMountImpl;
import org.cryptomator.jfuse.win.StatImpl;
import org.cryptomator.jfuse.win.StatvfsImpl;
import org.cryptomator.jfuse.win.TimeSpecImpl;
import org.cryptomator.jfuse.win.extr.fuse2.fuse2_h;
import org.cryptomator.jfuse.win.extr.fuse2.fuse_args;
import org.cryptomator.jfuse.win.extr.fuse3.fuse3_operations;
import org.cryptomator.jfuse.win.extr.fuse3.fuse_h;
import org.cryptomator.jfuse.win.extr.fuse3.fuse_timespec;
import org.jetbrains.annotations.VisibleForTesting;

class FuseImpl
extends Fuse {
    public FuseImpl(FuseOperations fuseOperations) {
        super(fuseOperations, fuse3_operations::allocate);
    }

    public synchronized void mount(String progName, Path mountPoint, String ... flags) throws FuseMountFailedException {
        Path adjustedMP = mountPoint;
        if (mountPoint.equals(mountPoint.getRoot()) && mountPoint.isAbsolute()) {
            adjustedMP = Path.of(mountPoint.toString().charAt(0) + ":", new String[0]);
        }
        super.mount(progName, adjustedMP, flags);
    }

    protected FuseMount mount(List<String> args) throws FuseMountFailedException {
        FuseArgs fuseArgs = this.parseArgs(args);
        MemorySegment fuse = fuse_h.fuse3_new(fuseArgs.args(), this.fuseOperationsStruct, this.fuseOperationsStruct.byteSize(), MemorySegment.NULL);
        if (MemorySegment.NULL.equals(fuse)) {
            throw new FuseMountFailedException("fuse_new failed");
        }
        if (fuse_h.fuse3_mount(fuse, fuseArgs.mountPoint()) != 0) {
            throw new FuseMountFailedException("fuse_mount failed");
        }
        return new FuseMountImpl(fuse, fuseArgs);
    }

    @VisibleForTesting
    FuseArgs parseArgs(List<String> cmdLineArgs) throws IllegalArgumentException {
        MemorySegment args = fuse_args.allocate(this.fuseArena);
        int argc = cmdLineArgs.size();
        MemorySegment argv = this.fuseArena.allocate(ValueLayout.ADDRESS, (long)argc + 1L);
        for (int i = 0; i < argc; ++i) {
            MemorySegment cString = this.fuseArena.allocateFrom(cmdLineArgs.get(i));
            argv.setAtIndex(ValueLayout.ADDRESS, (long)i, cString);
        }
        argv.setAtIndex(ValueLayout.ADDRESS, (long)argc, MemorySegment.NULL);
        fuse_args.argc(args, argc);
        fuse_args.argv(args, argv);
        fuse_args.allocated(args, 0);
        MemorySegment multithreaded = this.fuseArena.allocate(ValueLayout.JAVA_INT, 1L);
        MemorySegment foreground = this.fuseArena.allocate(ValueLayout.JAVA_INT, 1L);
        MemorySegment mountPointPtr = this.fuseArena.allocate(ValueLayout.ADDRESS);
        int parseResult = fuse2_h.fuse_parse_cmdline(args, mountPointPtr, multithreaded, foreground);
        if (parseResult != 0) {
            throw new IllegalArgumentException("fuse_parse_cmdline failed to parse " + String.join((CharSequence)" ", cmdLineArgs));
        }
        boolean isMultiThreaded = multithreaded.get(ValueLayout.JAVA_INT, 0L) == 1;
        MemorySegment mountPoint = mountPointPtr.get(ValueLayout.ADDRESS.withoutTargetLayout().withName("mountpoint"), 0L);
        return new FuseArgs(args, mountPoint, isMultiThreaded);
    }

    protected void bind(FuseOperations.Operation operation) {
        switch (operation) {
            case INIT: {
                fuse3_operations.init(this.fuseOperationsStruct, fuse3_operations.init.allocate(this::init, this.fuseArena));
                break;
            }
            case ACCESS: {
                fuse3_operations.access(this.fuseOperationsStruct, MemorySegment.NULL);
                break;
            }
            case CHMOD: {
                fuse3_operations.chmod(this.fuseOperationsStruct, fuse3_operations.chmod.allocate(this::chmod, this.fuseArena));
                break;
            }
            case CHOWN: {
                fuse3_operations.chown(this.fuseOperationsStruct, fuse3_operations.chown.allocate(this::chown, this.fuseArena));
                break;
            }
            case CREATE: {
                fuse3_operations.create(this.fuseOperationsStruct, fuse3_operations.create.allocate(this::create, this.fuseArena));
                break;
            }
            case DESTROY: {
                fuse3_operations.destroy(this.fuseOperationsStruct, fuse3_operations.destroy.allocate(this::destroy, this.fuseArena));
                break;
            }
            case FLUSH: {
                fuse3_operations.flush(this.fuseOperationsStruct, fuse3_operations.flush.allocate(this::flush, this.fuseArena));
                break;
            }
            case FSYNC: {
                fuse3_operations.fsync(this.fuseOperationsStruct, fuse3_operations.fsync.allocate(this::fsync, this.fuseArena));
                break;
            }
            case FSYNCDIR: {
                fuse3_operations.fsyncdir(this.fuseOperationsStruct, fuse3_operations.fsyncdir.allocate(this::fsyncdir, this.fuseArena));
                break;
            }
            case GET_ATTR: {
                fuse3_operations.getattr(this.fuseOperationsStruct, fuse3_operations.getattr.allocate(this::getattr, this.fuseArena));
                break;
            }
            case GET_XATTR: {
                fuse3_operations.getxattr(this.fuseOperationsStruct, fuse3_operations.getxattr.allocate(this::getxattr, this.fuseArena));
                break;
            }
            case LIST_XATTR: {
                fuse3_operations.listxattr(this.fuseOperationsStruct, fuse3_operations.listxattr.allocate(this::listxattr, this.fuseArena));
                break;
            }
            case MKDIR: {
                fuse3_operations.mkdir(this.fuseOperationsStruct, fuse3_operations.mkdir.allocate(this::mkdir, this.fuseArena));
                break;
            }
            case OPEN: {
                fuse3_operations.open(this.fuseOperationsStruct, fuse3_operations.open.allocate(this::open, this.fuseArena));
                break;
            }
            case OPEN_DIR: {
                fuse3_operations.opendir(this.fuseOperationsStruct, fuse3_operations.opendir.allocate(this::opendir, this.fuseArena));
                break;
            }
            case READ: {
                fuse3_operations.read(this.fuseOperationsStruct, fuse3_operations.read.allocate(this::read, this.fuseArena));
                break;
            }
            case READ_DIR: {
                fuse3_operations.readdir(this.fuseOperationsStruct, fuse3_operations.readdir.allocate(this::readdir, this.fuseArena));
                break;
            }
            case READLINK: {
                fuse3_operations.readlink(this.fuseOperationsStruct, fuse3_operations.readlink.allocate(this::readlink, this.fuseArena));
                break;
            }
            case RELEASE: {
                fuse3_operations.release(this.fuseOperationsStruct, fuse3_operations.release.allocate(this::release, this.fuseArena));
                break;
            }
            case RELEASE_DIR: {
                fuse3_operations.releasedir(this.fuseOperationsStruct, fuse3_operations.releasedir.allocate(this::releasedir, this.fuseArena));
                break;
            }
            case REMOVE_XATTR: {
                fuse3_operations.removexattr(this.fuseOperationsStruct, fuse3_operations.removexattr.allocate(this::removexattr, this.fuseArena));
                break;
            }
            case RENAME: {
                fuse3_operations.rename(this.fuseOperationsStruct, fuse3_operations.rename.allocate(this::rename, this.fuseArena));
                break;
            }
            case RMDIR: {
                fuse3_operations.rmdir(this.fuseOperationsStruct, fuse3_operations.rmdir.allocate(this::rmdir, this.fuseArena));
                break;
            }
            case SET_XATTR: {
                fuse3_operations.setxattr(this.fuseOperationsStruct, fuse3_operations.setxattr.allocate(this::setxattr, this.fuseArena));
                break;
            }
            case STATFS: {
                fuse3_operations.statfs(this.fuseOperationsStruct, fuse3_operations.statfs.allocate(this::statfs, this.fuseArena));
                break;
            }
            case SYMLINK: {
                fuse3_operations.symlink(this.fuseOperationsStruct, fuse3_operations.symlink.allocate(this::symlink, this.fuseArena));
                break;
            }
            case TRUNCATE: {
                fuse3_operations.truncate(this.fuseOperationsStruct, fuse3_operations.truncate.allocate(this::truncate, this.fuseArena));
                break;
            }
            case UNLINK: {
                fuse3_operations.unlink(this.fuseOperationsStruct, fuse3_operations.unlink.allocate(this::unlink, this.fuseArena));
                break;
            }
            case UTIMENS: {
                fuse3_operations.utimens(this.fuseOperationsStruct, fuse3_operations.utimens.allocate(this::utimens, this.fuseArena));
                break;
            }
            case WRITE: {
                fuse3_operations.write(this.fuseOperationsStruct, fuse3_operations.write.allocate(this::write, this.fuseArena));
            }
        }
    }

    @VisibleForTesting
    MemorySegment init(MemorySegment conn, MemorySegment cfg) {
        FuseConnInfoImpl connInfo = new FuseConnInfoImpl(conn);
        connInfo.setWant(connInfo.want() | 0x2000);
        FuseConfigImpl config = new FuseConfigImpl(cfg);
        this.fuseOperations.init((FuseConnInfo)connInfo, (FuseConfig)config);
        return MemorySegment.NULL;
    }

    private int chmod(MemorySegment path, int mode, MemorySegment fi) {
        return this.fuseOperations.chmod(path.getString(0L), mode, (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    @VisibleForTesting
    int chown(MemorySegment path, int uid, int gid, MemorySegment fi) {
        return this.fuseOperations.chown(path.getString(0L), uid, gid, (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    private int create(MemorySegment path, int mode, MemorySegment fi) {
        return this.fuseOperations.create(path.getString(0L), mode, (FileInfo)new FileInfoImpl(fi));
    }

    private void destroy(MemorySegment addr) {
        this.fuseOperations.destroy();
    }

    @VisibleForTesting
    int flush(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.flush(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    @VisibleForTesting
    int fsync(MemorySegment path, int datasync, MemorySegment fi) {
        return this.fuseOperations.fsync(path.getString(0L), datasync, (FileInfo)new FileInfoImpl(fi));
    }

    @VisibleForTesting
    int fsyncdir(MemorySegment path, int datasync, MemorySegment fi) {
        return this.fuseOperations.fsyncdir(MemoryUtils.toUtf8StringOrNull((MemorySegment)path), datasync, (FileInfo)new FileInfoImpl(fi));
    }

    @VisibleForTesting
    int getattr(MemorySegment path, MemorySegment stat, MemorySegment fi) {
        return this.fuseOperations.getattr(path.getString(0L), (Stat)new StatImpl(stat), (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    @VisibleForTesting
    int getxattr(MemorySegment path, MemorySegment name, MemorySegment value, long size) {
        ByteBuffer val = value.reinterpret(size).asByteBuffer();
        return this.fuseOperations.getxattr(path.getString(0L), name.getString(0L), val);
    }

    @VisibleForTesting
    int setxattr(MemorySegment path, MemorySegment name, MemorySegment value, long size, int flags) {
        ByteBuffer val = value.reinterpret(size).asByteBuffer();
        return this.fuseOperations.setxattr(path.getString(0L), name.getString(0L), val, flags);
    }

    @VisibleForTesting
    int listxattr(MemorySegment path, MemorySegment value, long size) {
        ByteBuffer val = value.reinterpret(size).asByteBuffer();
        return this.fuseOperations.listxattr(path.getString(0L), val);
    }

    @VisibleForTesting
    int removexattr(MemorySegment path, MemorySegment name) {
        return this.fuseOperations.removexattr(path.getString(0L), name.getString(0L));
    }

    private int mkdir(MemorySegment path, int mode) {
        return this.fuseOperations.mkdir(path.getString(0L), mode);
    }

    private int open(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.open(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    private int opendir(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.opendir(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    private int read(MemorySegment path, MemorySegment buf, long size, long offset, MemorySegment fi) {
        ByteBuffer buffer = buf.reinterpret(size).asByteBuffer();
        return this.fuseOperations.read(path.getString(0L), buffer, size, offset, (FileInfo)new FileInfoImpl(fi));
    }

    private int readdir(MemorySegment path, MemorySegment buf, MemorySegment filler, long offset, MemorySegment fi, int flags) {
        try (Arena arena = Arena.ofConfined();){
            int n = this.fuseOperations.readdir(path.getString(0L), (DirFiller)new DirFillerImpl(buf, filler, arena), offset, (FileInfo)new FileInfoImpl(fi), flags);
            return n;
        }
    }

    private int readlink(MemorySegment path, MemorySegment buf, long len) {
        ByteBuffer buffer = buf.reinterpret(len).asByteBuffer();
        return this.fuseOperations.readlink(path.getString(0L), buffer, len);
    }

    private int release(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.release(path.getString(0L), (FileInfo)new FileInfoImpl(fi));
    }

    private int releasedir(MemorySegment path, MemorySegment fi) {
        return this.fuseOperations.releasedir(MemoryUtils.toUtf8StringOrNull((MemorySegment)path), (FileInfo)new FileInfoImpl(fi));
    }

    private int rename(MemorySegment oldpath, MemorySegment newpath, int flags) {
        return this.fuseOperations.rename(oldpath.getString(0L), newpath.getString(0L), flags);
    }

    private int rmdir(MemorySegment path) {
        return this.fuseOperations.rmdir(path.getString(0L));
    }

    private int statfs(MemorySegment path, MemorySegment statvfs) {
        return this.fuseOperations.statfs(path.getString(0L), (Statvfs)new StatvfsImpl(statvfs));
    }

    private int symlink(MemorySegment linkname, MemorySegment target) {
        return this.fuseOperations.symlink(linkname.getString(0L), target.getString(0L));
    }

    @VisibleForTesting
    int truncate(MemorySegment path, long size, MemorySegment fi) {
        return this.fuseOperations.truncate(path.getString(0L), size, (FileInfo)FileInfoImpl.ofNullable(fi));
    }

    private int unlink(MemorySegment path) {
        return this.fuseOperations.unlink(path.getString(0L));
    }

    @VisibleForTesting
    int utimens(MemorySegment path, MemorySegment times, MemorySegment fi) {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment time0 = fuse_timespec.asSlice(times, 0L);
            MemorySegment time1 = fuse_timespec.asSlice(times, 1L);
            int n = this.fuseOperations.utimens(path.getString(0L), (TimeSpec)new TimeSpecImpl(time0), (TimeSpec)new TimeSpecImpl(time1), (FileInfo)FileInfoImpl.ofNullable(fi));
            return n;
        }
    }

    private int write(MemorySegment path, MemorySegment buf, long size, long offset, MemorySegment fi) {
        ByteBuffer buffer = buf.reinterpret(size).asByteBuffer();
        return this.fuseOperations.write(path.getString(0L), buffer, size, offset, (FileInfo)new FileInfoImpl(fi));
    }
}

