/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.webdav.core.filters;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.FilterChain;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.cryptomator.webdav.core.filters.HttpFilter;

public class MacChunkedPutCompatibilityFilter
implements HttpFilter {
    private static final String METHOD_PUT = "PUT";
    private static final String HEADER_TRANSFER_ENCODING = "Transfer-Encoding";
    private static final String HEADER_X_EXPECTED_ENTITIY_LENGTH = "X-Expected-Entity-Length";
    private static final String HEADER_TRANSFER_ENCODING_CHUNKED = "chunked";

    @Override
    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String expectedEntitiyLengthHeader = request.getHeader(HEADER_X_EXPECTED_ENTITIY_LENGTH);
        if (METHOD_PUT.equalsIgnoreCase(request.getMethod()) && HEADER_TRANSFER_ENCODING_CHUNKED.equalsIgnoreCase(request.getHeader(HEADER_TRANSFER_ENCODING)) && expectedEntitiyLengthHeader != null) {
            long expectedEntitiyLength;
            try {
                expectedEntitiyLength = Long.valueOf(expectedEntitiyLengthHeader);
            }
            catch (NumberFormatException e) {
                response.sendError(400, "Invalid X-Expected-Entity-Length");
                return;
            }
            chain.doFilter((ServletRequest)new PutRequestWithBoundedInputStream(request, expectedEntitiyLength), (ServletResponse)response);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private static class PutRequestWithBoundedInputStream
    extends HttpServletRequestWrapper {
        private final long inputStreamLimit;

        public PutRequestWithBoundedInputStream(HttpServletRequest request, long inputStreamLimit) {
            super(request);
            this.inputStreamLimit = inputStreamLimit;
        }

        public ServletInputStream getInputStream() throws IOException {
            return new BoundedServletInputStream(super.getInputStream(), this.inputStreamLimit);
        }
    }

    private static class BoundedServletInputStream
    extends ServletInputStream {
        private final InputStream boundedIn;
        private final ServletInputStream servletIn;
        private boolean reachedEof = false;
        private ReadListener readListener;

        public BoundedServletInputStream(ServletInputStream delegate, long limit) {
            this.boundedIn = ByteStreams.limit((InputStream)delegate, (long)limit);
            this.servletIn = delegate;
        }

        private void reachedEof() throws IOException {
            this.reachedEof = true;
            if (this.readListener != null) {
                this.readListener.onAllDataRead();
            }
        }

        public long skip(long n) throws IOException {
            return this.boundedIn.skip(n);
        }

        public int available() throws IOException {
            return this.boundedIn.available();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.boundedIn.read(b, off, len);
            if (read == -1) {
                this.reachedEof();
            }
            return read;
        }

        public int read() throws IOException {
            int aByte = this.boundedIn.read();
            if (aByte == -1) {
                this.reachedEof();
            }
            return aByte;
        }

        public boolean isFinished() {
            return this.reachedEof || this.servletIn.isFinished();
        }

        public boolean isReady() {
            return !this.reachedEof && this.servletIn.isReady();
        }

        public void setReadListener(ReadListener readListener) {
            this.servletIn.setReadListener(readListener);
            this.readListener = readListener;
        }
    }
}

