/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.cryptomator.frontend.webdav.VersionCompare;
import org.cryptomator.frontend.webdav.WebDavServerHandle;
import org.cryptomator.frontend.webdav.mount.AbstractMount;
import org.cryptomator.frontend.webdav.mount.AbstractMountBuilder;
import org.cryptomator.frontend.webdav.mount.ProcessUtil;
import org.cryptomator.frontend.webdav.servlet.WebDavServletController;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.mount.Mount;
import org.cryptomator.integrations.mount.MountBuilder;
import org.cryptomator.integrations.mount.MountCapability;
import org.cryptomator.integrations.mount.MountFailedException;
import org.cryptomator.integrations.mount.MountService;
import org.cryptomator.integrations.mount.Mountpoint;
import org.cryptomator.integrations.mount.UnmountFailedException;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=50)
@OperatingSystem(value=OperatingSystem.Value.MAC)
public class MacAppleScriptMounter
implements MountService {
    private static final Logger LOG = LoggerFactory.getLogger(MacAppleScriptMounter.class);
    private static final String OS_VERSION = System.getProperty("os.version");
    private static final Pattern MOUNT_PATTERN = Pattern.compile(".* on (\\S+) \\(.*\\)");

    public String displayName() {
        return "WebDAV (AppleScript)";
    }

    public boolean isSupported() {
        try {
            return VersionCompare.compareVersions(OS_VERSION, "10.10") >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public Set<MountCapability> capabilities() {
        return Set.of(MountCapability.LOOPBACK_PORT, MountCapability.UNMOUNT_FORCED, MountCapability.VOLUME_ID, MountCapability.VOLUME_NAME);
    }

    public @Range(from=0L, to=32767L) int getDefaultLoopbackPort() {
        return 42427;
    }

    public MountBuilder forFileSystem(Path path) {
        return new MountBuilderImpl(path);
    }

    private static class MountBuilderImpl
    extends AbstractMountBuilder {
        private String volumeName;

        public MountBuilderImpl(Path vfsRoot) {
            super(vfsRoot);
        }

        public MountBuilder setVolumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        @Override
        protected String getContextPath() {
            return super.getContextPath() + "/" + this.volumeName;
        }

        @Override
        protected Mount mount(WebDavServerHandle serverHandle, WebDavServletController servlet, URI uri) throws MountFailedException {
            try {
                ProcessBuilder storeCredentials = new ProcessBuilder("security", "add-internet-password", "-a", "anonymous", "-s", "localhost", "-P", String.valueOf(uri.getPort()), "-r", "http", "-D", "Cryptomator WebDAV Access", "-T", "/System/Library/CoreServices/NetAuthAgent.app/Contents/MacOS/NetAuthSysAgent");
                ProcessUtil.startAndWaitFor(storeCredentials, 10L, TimeUnit.SECONDS);
            }
            catch (IOException | TimeoutException e) {
                LOG.warn("Unable to store credentials for WebDAV access: {}", (Object)e.getMessage());
            }
            try {
                String mountAppleScript = String.format("mount volume \"%s\"", uri.toASCIIString());
                ProcessBuilder mount = new ProcessBuilder("/usr/bin/osascript", "-e", mountAppleScript);
                Process mountProcess = mount.start();
                ProcessUtil.waitFor(mountProcess, 120L, TimeUnit.SECONDS);
                ProcessUtil.assertExitValue(mountProcess, 0);
                ProcessBuilder verifyMount = new ProcessBuilder("/bin/sh", "-c", "mount | grep \"" + uri.toASCIIString() + "\"");
                Process verifyProcess = verifyMount.start();
                String stdout = verifyProcess.inputReader(StandardCharsets.UTF_8).lines().collect(Collectors.joining("\n"));
                ProcessUtil.waitFor(verifyProcess, 10L, TimeUnit.SECONDS);
                ProcessUtil.assertExitValue(mountProcess, 0);
                Matcher mountPointMatcher = MOUNT_PATTERN.matcher(stdout);
                if (mountPointMatcher.find()) {
                    String mountPoint = mountPointMatcher.group(1);
                    LOG.debug("Mounted {} on {}.", (Object)uri.toASCIIString(), (Object)mountPoint);
                    return new MountImpl(serverHandle, servlet, Paths.get(mountPoint, new String[0]));
                }
                throw new MountFailedException("Mount succeeded, but failed to determine mount point in string: " + stdout);
            }
            catch (IOException | TimeoutException e) {
                throw new MountFailedException("Mounting failed", e);
            }
        }
    }

    private static class MountImpl
    extends AbstractMount {
        private final Path mountPath;
        private final ProcessBuilder unmountCommand;
        private final ProcessBuilder forcedUnmountCommand;

        private MountImpl(WebDavServerHandle serverHandle, WebDavServletController servlet, Path mountPath) {
            super(serverHandle, servlet);
            this.mountPath = mountPath;
            this.unmountCommand = new ProcessBuilder("sh", "-c", "diskutil umount \"" + String.valueOf(mountPath) + "\"");
            this.forcedUnmountCommand = new ProcessBuilder("sh", "-c", "diskutil umount force \"" + String.valueOf(mountPath) + "\"");
        }

        public Mountpoint getMountpoint() {
            return Mountpoint.forPath((Path)this.mountPath);
        }

        @Override
        public void unmount() throws UnmountFailedException {
            this.unmount(this.unmountCommand);
        }

        public void unmountForced() throws UnmountFailedException {
            this.unmount(this.forcedUnmountCommand);
        }

        private void unmount(ProcessBuilder command) throws UnmountFailedException {
            if (!Files.isDirectory(this.mountPath, new LinkOption[0])) {
                LOG.debug("Volume already unmounted.");
                return;
            }
            try {
                ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(command, 10L, TimeUnit.SECONDS), 0);
                super.unmount();
            }
            catch (IOException | TimeoutException e) {
                throw new UnmountFailedException(e);
            }
        }
    }
}

